/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.hash;

import com.netflix.zeno.hash.HashAlgorithm;
import java.io.IOException;

public final class HashOrderIndependent
implements HashAlgorithm {
    long hashCode = 0L;

    private static long hash(long h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    @Override
    public void write(char b) throws IOException {
        this.write("char");
        this.write((long)b);
    }

    @Override
    public void write(boolean b) throws IOException {
        this.write("boolean");
        this.write(b ? -267653109 : -132398025);
    }

    @Override
    public void write(long b) throws IOException {
        this.write("long");
        this.hashCode += HashOrderIndependent.hash(b);
    }

    @Override
    public void write(float b) throws IOException {
        this.write("float");
        this.write(Float.floatToIntBits(b));
    }

    @Override
    public void write(double b) throws IOException {
        this.write("double");
        this.write(Double.doubleToLongBits(b));
    }

    @Override
    public void write(String b) throws IOException {
        long code = 0L;
        for (int i = 0; i < b.length(); ++i) {
            code = 31L * code + (long)b.charAt(i);
        }
        this.hashCode += HashOrderIndependent.hash(code);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write("byte[]");
        long code = 0L;
        for (int i = 0; i < b.length; ++i) {
            code = 31L * code + (long)b[i];
        }
        this.write(code);
    }

    @Override
    public void write(char[] b) throws IOException {
        this.write("char[]");
        long code = 0L;
        for (int i = 0; i < b.length; ++i) {
            code = 31L * code + (long)b[i];
        }
        this.write(code);
    }

    @Override
    public void write(boolean[] b) throws IOException {
        this.write("boolean[]");
        long code = 0L;
        for (int i = 0; i < b.length; ++i) {
            code = 31L * code + (long)(b[i] ? 2 : 1);
        }
        this.write(code);
    }

    @Override
    public void write(short[] b) throws IOException {
        this.write("short[]");
        long code = 0L;
        for (int i = 0; i < b.length; ++i) {
            code = 31L * code + (long)b[i];
        }
        this.write(code);
    }

    @Override
    public void write(int[] b) throws IOException {
        this.write("int[]");
        long code = 0L;
        for (int i = 0; i < b.length; ++i) {
            code = 31L * code + (long)b[i];
        }
        this.write(code);
    }

    @Override
    public void write(long[] b) throws IOException {
        this.write("long[]");
        long code = 0L;
        for (int i = 0; i < b.length; ++i) {
            code = 31L * code + b[i];
        }
        this.write(code);
    }

    @Override
    public void write(float[] b) throws IOException {
        this.write("float[]");
        long code = 0L;
        for (int i = 0; i < b.length; ++i) {
            code = 31L * code + (long)Float.floatToIntBits(b[i]);
        }
        this.write(code);
    }

    @Override
    public void write(double[] b) throws IOException {
        this.write("double[]");
        long code = 0L;
        for (int i = 0; i < b.length; ++i) {
            code = 31L * code + Double.doubleToLongBits(b[i]);
        }
        this.write(code);
    }

    @Override
    public byte[] bytes() {
        return new byte[]{(byte)(this.hashCode >> 56 & 0xFFL), (byte)(this.hashCode >> 48 & 0xFFL), (byte)(this.hashCode >> 40 & 0xFFL), (byte)(this.hashCode >> 32 & 0xFFL), (byte)(this.hashCode >> 24 & 0xFFL), (byte)(this.hashCode >> 16 & 0xFFL), (byte)(this.hashCode >> 8 & 0xFFL), (byte)(this.hashCode >> 0 & 0xFFL)};
    }
}

