/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.netflix.zeno.json.JsonReadGenericRecord;
import com.netflix.zeno.json.JsonSerializationFramework;
import com.netflix.zeno.serializer.FrameworkDeserializer;
import com.netflix.zeno.serializer.NFTypeSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Base64;

public class JsonFrameworkDeserializer
extends FrameworkDeserializer<JsonReadGenericRecord> {
    JsonFrameworkDeserializer(JsonSerializationFramework framework) {
        super(framework);
    }

    @Override
    public Boolean deserializeBoolean(JsonReadGenericRecord rec, String fieldName) {
        JsonNode node;
        JsonReadGenericRecord record = rec;
        JsonNode jsonNode = node = record.getNode().isBoolean() ? record.getNode() : this.getJsonNode(rec, fieldName);
        if (node == null) {
            return null;
        }
        return node.booleanValue();
    }

    @Override
    public Integer deserializeInteger(JsonReadGenericRecord record, String fieldName) {
        JsonNode node;
        JsonNode jsonNode = node = record.getNode().isNumber() ? record.getNode() : this.getJsonNode(record, fieldName);
        if (node == null) {
            return null;
        }
        return node.intValue();
    }

    @Override
    public Long deserializeLong(JsonReadGenericRecord record, String fieldName) {
        JsonNode node;
        JsonNode jsonNode = node = record.getNode().isNumber() ? record.getNode() : this.getJsonNode(record, fieldName);
        if (node == null) {
            return null;
        }
        return node.longValue();
    }

    @Override
    public Float deserializeFloat(JsonReadGenericRecord record, String fieldName) {
        JsonNode node;
        JsonNode jsonNode = node = record.getNode().isNumber() ? record.getNode() : this.getJsonNode(record, fieldName);
        if (node == null) {
            return null;
        }
        return Float.valueOf(node.numberValue().floatValue());
    }

    @Override
    public Double deserializeDouble(JsonReadGenericRecord record, String fieldName) {
        JsonNode node;
        JsonNode jsonNode = node = record.getNode().isNumber() ? record.getNode() : this.getJsonNode(record, fieldName);
        if (node == null) {
            return null;
        }
        return node.numberValue().doubleValue();
    }

    @Override
    public String deserializeString(JsonReadGenericRecord record, String fieldName) {
        JsonNode node;
        JsonNode jsonNode = node = record.getNode().isTextual() ? record.getNode() : this.getJsonNode(record, fieldName);
        if (node == null) {
            return null;
        }
        return node.textValue();
    }

    @Override
    @Deprecated
    public <T> T deserializeObject(JsonReadGenericRecord rec, String fieldName, String typeName, Class<T> clazz) {
        JsonNode node = this.getJsonNode(rec, fieldName);
        if (node == null) {
            return null;
        }
        return this.deserializeObject(rec, typeName, node);
    }

    private <T> T deserializeObject(JsonReadGenericRecord rec, String typeName, JsonNode node) {
        NFTypeSerializer serializer = this.framework.getSerializer(typeName);
        return serializer.deserialize(new JsonReadGenericRecord(serializer.getFastBlobSchema(), node));
    }

    @Override
    public <T> T deserializeObject(JsonReadGenericRecord rec, String fieldName, Class<T> clazz) {
        JsonNode node = this.getJsonNode(rec, fieldName);
        if (node == null) {
            return null;
        }
        return this.deserializeObject(rec, rec.getObjectType(fieldName), node);
    }

    @Override
    public <T> List<T> deserializeList(JsonReadGenericRecord record, String fieldName, NFTypeSerializer<T> itemSerializer) {
        JsonNode node = this.getJsonNode(record, "list");
        if (node == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        this.deserializeCollection(node, itemSerializer, list);
        return list;
    }

    @Override
    public <T> Set<T> deserializeSet(JsonReadGenericRecord record, String fieldName, NFTypeSerializer<T> itemSerializer) {
        JsonNode node = this.getJsonNode(record, "set");
        if (node == null) {
            return null;
        }
        HashSet set = new HashSet();
        this.deserializeCollection(node, itemSerializer, set);
        return set;
    }

    private JsonNode getJsonNode(Object rec, String fieldName) {
        JsonReadGenericRecord record = (JsonReadGenericRecord)rec;
        JsonNode node = record.getNode().get(fieldName);
        if (node == null || node.isNull()) {
            return null;
        }
        return node;
    }

    private <T> void deserializeCollection(JsonNode nodes, NFTypeSerializer<T> itemSerializer, Collection<T> elements) {
        try {
            Iterator it = nodes.elements();
            while (it.hasNext()) {
                JsonNode node = (JsonNode)it.next();
                T element = itemSerializer.deserialize(new JsonReadGenericRecord(itemSerializer.getFastBlobSchema(), node));
                elements.add(element);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public <K, V> Map<K, V> deserializeMap(JsonReadGenericRecord record, String fieldName, NFTypeSerializer<K> keySerializer, NFTypeSerializer<V> valueSerializer) {
        return this.deserializeIntoMap(record, fieldName, keySerializer, valueSerializer, new HashMap());
    }

    @Override
    public byte[] deserializeBytes(JsonReadGenericRecord record, String fieldName) {
        String str = this.deserializeString(record, fieldName);
        if (str == null) {
            return null;
        }
        return Base64.decodeBase64((String)str);
    }

    @Override
    public <K, V> SortedMap<K, V> deserializeSortedMap(JsonReadGenericRecord record, String fieldName, NFTypeSerializer<K> keySerializer, NFTypeSerializer<V> valueSerializer) {
        return this.deserializeIntoMap(record, fieldName, keySerializer, valueSerializer, new TreeMap());
    }

    private <K, V, M extends Map<K, V>> M deserializeIntoMap(JsonReadGenericRecord rec, String fieldName, NFTypeSerializer<K> keySerializer, NFTypeSerializer<V> valueSerializer, M map) {
        JsonNode node = this.getJsonNode(rec, fieldName);
        if (node == null) {
            return null;
        }
        Iterator it = node.elements();
        while (it.hasNext()) {
            JsonNode element = (JsonNode)it.next();
            K key = keySerializer.deserialize(new JsonReadGenericRecord(keySerializer.getFastBlobSchema(), element.get("key")));
            V value = valueSerializer.deserialize(new JsonReadGenericRecord(valueSerializer.getFastBlobSchema(), element.get("value")));
            map.put(key, value);
        }
        return map;
    }
}

