/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.json;

import com.netflix.zeno.json.JsonWriteGenericRecord;
import com.netflix.zeno.serializer.FrameworkSerializer;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.SerializationFramework;
import com.netflix.zeno.util.PrimitiveObjectIdentifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;

public class JsonFrameworkSerializer
extends FrameworkSerializer<JsonWriteGenericRecord> {
    JsonFrameworkSerializer(SerializationFramework framework) {
        super(framework);
    }

    @Override
    public void serializePrimitive(JsonWriteGenericRecord rec, String fieldName, Object value) {
        JsonWriteGenericRecord record = rec;
        try {
            if (value != null && value.getClass().isEnum()) {
                value = ((Enum)value).name();
            }
            record.getGenerator().writeObjectField(fieldName, value);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void serializeBytes(JsonWriteGenericRecord rec, String fieldName, byte[] value) {
        String str = null;
        if (value != null) {
            byte[] encoded = Base64.encodeBase64((byte[])value, (boolean)false);
            str = new String(encoded, Charset.forName("UTF-8"));
        }
        this.serializePrimitive(rec, fieldName, (Object)str);
    }

    private static boolean isPrimitive(Class<?> type) {
        return type.isEnum() || PrimitiveObjectIdentifier.isPrimitiveOrWrapper(type);
    }

    @Override
    @Deprecated
    public void serializeObject(JsonWriteGenericRecord record, String fieldName, String typeName, Object obj) {
        try {
            if (obj == null) {
                record.getGenerator().writeObjectField(fieldName, null);
                return;
            }
            if (JsonFrameworkSerializer.isPrimitive(obj.getClass())) {
                this.serializePrimitive(record, fieldName, obj);
                return;
            }
            record.getGenerator().writeFieldName(fieldName);
            record.getGenerator().writeStartObject();
            NFTypeSerializer fieldSerializer = this.getSerializer(typeName);
            JsonWriteGenericRecord fieldRecord = new JsonWriteGenericRecord(record.getGenerator());
            fieldSerializer.serialize(obj, fieldRecord);
            record.getGenerator().writeEndObject();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void serializeObject(JsonWriteGenericRecord record, String fieldName, Object obj) {
        this.serializeObject(record, fieldName, record.getObjectType(fieldName), obj);
    }

    @Override
    public <T> void serializeList(JsonWriteGenericRecord rec, String fieldName, String typeName, Collection<T> obj) {
        this.serializeCollection(rec, "list", typeName, obj);
    }

    @Override
    public <T> void serializeSet(JsonWriteGenericRecord rec, String fieldName, String typeName, Set<T> obj) {
        this.serializeCollection(rec, "set", typeName, obj);
    }

    private <T> void serializeCollection(JsonWriteGenericRecord record, String fieldName, String typeName, Collection<T> obj) {
        try {
            if (obj == null) {
                record.getGenerator().writeObjectField(fieldName, null);
                return;
            }
            record.getGenerator().writeArrayFieldStart(fieldName);
            NFTypeSerializer elemSerializer = this.getSerializer(typeName);
            JsonWriteGenericRecord elemRecord = new JsonWriteGenericRecord(record.getGenerator());
            for (T t : obj) {
                record.getGenerator().writeStartObject();
                elemSerializer.serialize(t, elemRecord);
                record.getGenerator().writeEndObject();
            }
            record.getGenerator().writeEndArray();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public <K, V> void serializeMap(JsonWriteGenericRecord record, String fieldName, String keyTypeName, String valueTypeName, Map<K, V> obj) {
        try {
            if (obj == null) {
                record.getGenerator().writeObjectField(fieldName, null);
                return;
            }
            record.getGenerator().writeFieldName("map");
            record.getGenerator().writeStartArray();
            for (Map.Entry<K, V> entry : this.sortedEntryList(obj)) {
                record.getGenerator().writeStartObject();
                this.serializeObject(record, "key", keyTypeName, entry.getKey());
                this.serializeObject(record, "value", valueTypeName, entry.getValue());
                record.getGenerator().writeEndObject();
            }
            record.getGenerator().writeEndArray();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private <K, V> List<Map.Entry<K, V>> sortedEntryList(Map<K, V> obj) {
        ArrayList<Map.Entry<K, V>> entryList = new ArrayList<Map.Entry<K, V>>(obj.entrySet());
        Collections.sort(entryList, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                Object k1 = o1.getKey();
                Object k2 = o2.getKey();
                if (k1 instanceof Comparable) {
                    return ((Comparable)k1).compareTo(k2);
                }
                return k1.hashCode() - k2.hashCode();
            }
        });
        return entryList;
    }
}

