/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.zeno.json.JsonFrameworkDeserializer;
import com.netflix.zeno.json.JsonFrameworkSerializer;
import com.netflix.zeno.json.JsonReadGenericRecord;
import com.netflix.zeno.json.JsonWriteGenericRecord;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.SerializationFramework;
import com.netflix.zeno.serializer.SerializerFactory;
import com.netflix.zeno.serializer.common.MapSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;

public class JsonSerializationFramework
extends SerializationFramework {
    public JsonSerializationFramework(SerializerFactory factory) {
        super(factory);
        this.frameworkSerializer = new JsonFrameworkSerializer(this);
        this.frameworkDeserializer = new JsonFrameworkDeserializer(this);
    }

    public <T> String serializeAsJson(String type, T object) {
        return this.serializeAsJson(type, object, true);
    }

    public <T> String serializeAsJson(String type, T object, boolean pretty) {
        StringWriter writer = new StringWriter();
        JsonWriteGenericRecord record = new JsonWriteGenericRecord(writer, pretty);
        record.open();
        this.getSerializer(type).serialize(object, record);
        record.close();
        writer.flush();
        return writer.toString();
    }

    public <K, V> String serializeJsonMap(String keyType, String valueType, Map<K, V> map, boolean pretty) {
        NFTypeSerializer keySerializer = this.getSerializer(keyType);
        NFTypeSerializer valueSerializer = this.getSerializer(valueType);
        MapSerializer<Map<K, V>, Map<K, V>> mapSerializer = new MapSerializer<Map<K, V>, Map<K, V>>(keySerializer, valueSerializer);
        mapSerializer.setSerializationFramework(this);
        StringWriter writer = new StringWriter();
        JsonWriteGenericRecord record = new JsonWriteGenericRecord(writer, pretty);
        record.open();
        mapSerializer.serialize(map, record);
        record.close();
        writer.flush();
        return writer.toString();
    }

    public <T> T deserializeJson(String type, String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(json);
        NFTypeSerializer serializer = this.getSerializer(type);
        JsonReadGenericRecord readRecord = new JsonReadGenericRecord(serializer.getFastBlobSchema(), node);
        Object object = serializer.deserialize(readRecord);
        return object;
    }

    public <K, V> Map<K, V> deserializeJsonMap(String keyType, String valueType, String json) throws IOException {
        NFTypeSerializer keySerializer = this.getSerializer(keyType);
        NFTypeSerializer valueSerializer = this.getSerializer(valueType);
        MapSerializer mapSerializer = new MapSerializer(keySerializer, valueSerializer);
        mapSerializer.setSerializationFramework(this);
        JsonNode node = new ObjectMapper().readTree(json);
        JsonReadGenericRecord readRecord = new JsonReadGenericRecord(mapSerializer.getFastBlobSchema(), node);
        return (Map)mapSerializer.deserialize(readRecord);
    }
}

