/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.netflix.zeno.serializer.NFSerializationRecord;
import java.io.Writer;

public class JsonWriteGenericRecord
extends NFSerializationRecord {
    private static final JsonFactory s_jfactory = new JsonFactory();
    private static final DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
    private JsonGenerator jGenerator;

    public JsonWriteGenericRecord(Writer writer, boolean pretty) {
        this(writer);
        if (pretty) {
            this.jGenerator.setPrettyPrinter((PrettyPrinter)prettyPrinter);
        }
    }

    public JsonWriteGenericRecord(Writer writer) {
        try {
            this.jGenerator = s_jfactory.createGenerator(writer);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public JsonWriteGenericRecord(JsonGenerator jGenerator) {
        this.jGenerator = jGenerator;
    }

    public void open() {
        try {
            this.jGenerator.writeStartObject();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean closeGenerator) {
        try {
            this.jGenerator.writeEndObject();
            if (closeGenerator) {
                this.jGenerator.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public JsonGenerator getGenerator() {
        return this.jGenerator;
    }
}

