/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.serializer;

import com.netflix.zeno.serializer.NFDeserializationRecord;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.SerializationFramework;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public abstract class FrameworkDeserializer<D extends NFDeserializationRecord> {
    protected final SerializationFramework framework;

    protected FrameworkDeserializer(SerializationFramework framework) {
        this.framework = framework;
    }

    public abstract Boolean deserializeBoolean(D var1, String var2);

    public boolean deserializePrimitiveBoolean(D rec, String fieldName) {
        return this.deserializeBoolean(rec, fieldName);
    }

    public abstract Integer deserializeInteger(D var1, String var2);

    public int deserializePrimitiveInt(D rec, String fieldName) {
        return this.deserializeInteger(rec, fieldName);
    }

    public abstract Long deserializeLong(D var1, String var2);

    public long deserializePrimitiveLong(D rec, String fieldName) {
        return this.deserializeLong(rec, fieldName);
    }

    public abstract Float deserializeFloat(D var1, String var2);

    public float deserializePrimitiveFloat(D rec, String fieldName) {
        return this.deserializeFloat(rec, fieldName).floatValue();
    }

    public abstract Double deserializeDouble(D var1, String var2);

    public double deserializePrimitiveDouble(D rec, String fieldName) {
        return this.deserializeDouble(rec, fieldName);
    }

    public abstract String deserializeString(D var1, String var2);

    public abstract byte[] deserializeBytes(D var1, String var2);

    @Deprecated
    public abstract <T> T deserializeObject(D var1, String var2, String var3, Class<T> var4);

    public abstract <T> T deserializeObject(D var1, String var2, Class<T> var3);

    public abstract <T> List<T> deserializeList(D var1, String var2, NFTypeSerializer<T> var3);

    public abstract <T> Set<T> deserializeSet(D var1, String var2, NFTypeSerializer<T> var3);

    public abstract <K, V> Map<K, V> deserializeMap(D var1, String var2, NFTypeSerializer<K> var3, NFTypeSerializer<V> var4);

    public abstract <K, V> SortedMap<K, V> deserializeSortedMap(D var1, String var2, NFTypeSerializer<K> var3, NFTypeSerializer<V> var4);
}

