/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.serializer;

import com.netflix.zeno.serializer.NFSerializationRecord;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.SerializationFramework;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public abstract class FrameworkSerializer<S extends NFSerializationRecord> {
    protected final SerializationFramework framework;

    protected FrameworkSerializer(SerializationFramework framework) {
        this.framework = framework;
    }

    public NFTypeSerializer getSerializer(String typeName) {
        NFTypeSerializer serializer = this.framework.getSerializer(typeName);
        if (serializer == null) {
            throw new RuntimeException("Serializer " + typeName + " is not found");
        }
        return serializer;
    }

    public abstract void serializePrimitive(S var1, String var2, Object var3);

    public void serializePrimitive(S rec, String fieldName, int value) {
        this.serializePrimitive(rec, fieldName, (Object)value);
    }

    public void serializePrimitive(S rec, String fieldName, long value) {
        this.serializePrimitive(rec, fieldName, (Object)value);
    }

    public void serializePrimitive(S rec, String fieldName, float value) {
        this.serializePrimitive(rec, fieldName, Float.valueOf(value));
    }

    public void serializePrimitive(S rec, String fieldName, double value) {
        this.serializePrimitive(rec, fieldName, (Object)value);
    }

    public void serializePrimitive(S rec, String fieldName, boolean value) {
        this.serializePrimitive(rec, fieldName, (Object)value);
    }

    public abstract void serializeBytes(S var1, String var2, byte[] var3);

    @Deprecated
    public abstract void serializeObject(S var1, String var2, String var3, Object var4);

    public abstract void serializeObject(S var1, String var2, Object var3);

    public abstract <T> void serializeList(S var1, String var2, String var3, Collection<T> var4);

    public abstract <T> void serializeSet(S var1, String var2, String var3, Set<T> var4);

    public abstract <K, V> void serializeMap(S var1, String var2, String var3, String var4, Map<K, V> var5);

    public <K, V> void serializeSortedMap(S rec, String fieldName, String keyTypeName, String valueTypeName, SortedMap<K, V> obj) {
        this.serializeMap(rec, fieldName, keyTypeName, valueTypeName, obj);
    }
}

