/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.serializer;

import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.fastblob.record.schema.FieldDefinition;
import com.netflix.zeno.fastblob.record.schema.MapFieldDefinition;
import com.netflix.zeno.fastblob.record.schema.TypedFieldDefinition;
import com.netflix.zeno.serializer.FrameworkDeserializer;
import com.netflix.zeno.serializer.NFDeserializationRecord;
import com.netflix.zeno.serializer.NFSerializationRecord;
import com.netflix.zeno.serializer.SerializationFramework;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class NFTypeSerializer<T> {
    private final String schemaName;
    private FastBlobSchema schema;
    protected SerializationFramework serializationFramework;

    public NFTypeSerializer(String schemaName) {
        this.schemaName = schemaName;
    }

    public void serialize(T value, NFSerializationRecord rec) {
        FastBlobSchema existingSchema = rec.getSchema();
        rec.setSchema(this.getFastBlobSchema());
        this.doSerialize(value, rec);
        rec.setSchema(existingSchema);
    }

    public T deserialize(NFDeserializationRecord rec) {
        return this.doDeserialize(rec);
    }

    protected abstract void doSerialize(T var1, NFSerializationRecord var2);

    protected abstract T doDeserialize(NFDeserializationRecord var1);

    protected abstract FastBlobSchema createSchema();

    public abstract Collection<NFTypeSerializer<?>> requiredSubSerializers();

    public Collection<NFTypeSerializer<?>> requiredSubSerializers(FastBlobSchemaField[] fields) {
        HashSet requiredSubSerializers = new HashSet();
        for (FastBlobSchemaField field : fields) {
            if (field.typeSerializer == null) continue;
            requiredSubSerializers.add(field.typeSerializer);
        }
        return requiredSubSerializers;
    }

    protected void serializePrimitive(NFSerializationRecord rec, String fieldName, Object value) {
        this.serializationFramework.getFrameworkSerializer().serializePrimitive(rec, fieldName, value);
    }

    protected void serializeBytes(NFSerializationRecord rec, String fieldName, byte[] value) {
        this.serializationFramework.getFrameworkSerializer().serializeBytes(rec, fieldName, value);
    }

    @Deprecated
    protected void serializeObject(NFSerializationRecord rec, String fieldName, String typeName, Object obj) {
        this.serializationFramework.getFrameworkSerializer().serializeObject(rec, fieldName, typeName, obj);
    }

    protected void serializeObject(NFSerializationRecord rec, String fieldName, Object obj) {
        this.serializationFramework.getFrameworkSerializer().serializeObject(rec, fieldName, obj);
    }

    @Deprecated
    protected <X> X deserializeObject(NFDeserializationRecord rec, String typeName, String fieldName) {
        return (X)this.serializationFramework.getFrameworkDeserializer().deserializeObject(rec, fieldName, typeName, null);
    }

    protected <X> X deserializeObject(NFDeserializationRecord rec, String fieldName) {
        return (X)this.serializationFramework.getFrameworkDeserializer().deserializeObject(rec, fieldName, null);
    }

    public FastBlobSchema getFastBlobSchema() {
        if (this.schema == null) {
            this.schema = this.createSchema();
        }
        return this.schema;
    }

    public String getName() {
        return this.schemaName;
    }

    public void setSerializationFramework(SerializationFramework framework) {
        if (this.serializationFramework != null && this.serializationFramework != framework) {
            throw new RuntimeException("Should not be replacing an existing SerializationFramework with a different one!  This can cause bugs which are difficult to track down!");
        }
        this.serializationFramework = framework;
    }

    @Deprecated
    protected FastBlobSchemaField field(String name) {
        return this.field(name, FastBlobSchema.FieldType.OBJECT);
    }

    protected FastBlobSchemaField field(String name, String objectType) {
        FastBlobSchemaField field = new FastBlobSchemaField();
        field.name = name;
        field.type = new TypedFieldDefinition(FastBlobSchema.FieldType.OBJECT, objectType);
        return field;
    }

    protected FastBlobSchemaField field(String name, NFTypeSerializer<?> typeSerializer) {
        FastBlobSchemaField field = new FastBlobSchemaField();
        field.name = name;
        field.type = new TypedFieldDefinition(FastBlobSchema.FieldType.OBJECT, typeSerializer.getName());
        field.typeSerializer = typeSerializer;
        return field;
    }

    protected FastBlobSchemaField field(String name, FastBlobSchema.FieldType fieldType) {
        FastBlobSchemaField field = new FastBlobSchemaField();
        field.name = name;
        field.type = new FieldDefinition(fieldType);
        return field;
    }

    protected FastBlobSchemaField listField(String name, String elementType) {
        FastBlobSchemaField field = new FastBlobSchemaField();
        field.name = name;
        field.type = new TypedFieldDefinition(FastBlobSchema.FieldType.LIST, elementType);
        return field;
    }

    protected FastBlobSchemaField setField(String name, String elementType) {
        FastBlobSchemaField field = new FastBlobSchemaField();
        field.name = name;
        field.type = new TypedFieldDefinition(FastBlobSchema.FieldType.SET, elementType);
        return field;
    }

    protected FastBlobSchemaField mapField(String name, String keyType, String valueType) {
        FastBlobSchemaField field = new FastBlobSchemaField();
        field.name = name;
        field.type = new MapFieldDefinition(keyType, valueType);
        return field;
    }

    protected FastBlobSchema schema(FastBlobSchemaField ... fields) {
        FastBlobSchema schema = new FastBlobSchema(this.schemaName, fields.length);
        for (FastBlobSchemaField field : fields) {
            schema.addField(field.name, field.type);
        }
        return schema;
    }

    protected List<NFTypeSerializer<?>> serializers(NFTypeSerializer<?> ... serializers) {
        ArrayList list = new ArrayList();
        for (NFTypeSerializer<?> s : serializers) {
            list.add(s);
        }
        return list;
    }

    protected boolean deserializeBoolean(NFDeserializationRecord rec, String field) {
        FrameworkDeserializer frameworkSerializer = this.serializationFramework.getFrameworkDeserializer();
        return frameworkSerializer.deserializePrimitiveBoolean(rec, field);
    }

    protected boolean deserializeBoolean(NFDeserializationRecord rec, String field, boolean defaultVal) {
        Boolean recObj = this.serializationFramework.getFrameworkDeserializer().deserializeBoolean(rec, field);
        if (recObj == null) {
            return defaultVal;
        }
        return recObj;
    }

    protected Integer deserializeInteger(NFDeserializationRecord rec, String fieldName) {
        return this.serializationFramework.getFrameworkDeserializer().deserializeInteger(rec, fieldName);
    }

    protected int deserializePrimitiveInt(NFDeserializationRecord rec, String fieldName) {
        return this.serializationFramework.getFrameworkDeserializer().deserializePrimitiveInt(rec, fieldName);
    }

    protected Long deserializeLong(NFDeserializationRecord rec, String fieldName) {
        return this.serializationFramework.getFrameworkDeserializer().deserializeLong(rec, fieldName);
    }

    protected long deserializePrimitiveLong(NFDeserializationRecord rec, String fieldName) {
        return this.serializationFramework.getFrameworkDeserializer().deserializePrimitiveLong(rec, fieldName);
    }

    protected Float deserializeFloat(NFDeserializationRecord rec, String fieldName) {
        return this.serializationFramework.getFrameworkDeserializer().deserializeFloat(rec, fieldName);
    }

    protected float deserializePrimitiveFloat(NFDeserializationRecord rec, String fieldName) {
        return this.serializationFramework.getFrameworkDeserializer().deserializePrimitiveFloat(rec, fieldName);
    }

    protected Double deserializeDouble(NFDeserializationRecord rec, String fieldName) {
        return this.serializationFramework.getFrameworkDeserializer().deserializeDouble(rec, fieldName);
    }

    protected double deserializePrimitiveDouble(NFDeserializationRecord rec, String fieldName) {
        return this.serializationFramework.getFrameworkDeserializer().deserializePrimitiveDouble(rec, fieldName);
    }

    protected String deserializePrimitiveString(NFDeserializationRecord rec, String field) {
        return this.serializationFramework.getFrameworkDeserializer().deserializeString(rec, field);
    }

    protected byte[] deserializeBytes(NFDeserializationRecord rec, String field) {
        return this.serializationFramework.getFrameworkDeserializer().deserializeBytes(rec, field);
    }

    public SerializationFramework getSerializationFramework() {
        return this.serializationFramework;
    }

    public static class FastBlobSchemaField {
        public String name;
        public FieldDefinition type;
        public NFTypeSerializer<?> typeSerializer;
    }
}

