/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.serializer;

import com.netflix.zeno.serializer.FrameworkDeserializer;
import com.netflix.zeno.serializer.FrameworkSerializer;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.SerializerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SerializationFramework {
    protected FrameworkSerializer<?> frameworkSerializer;
    protected FrameworkDeserializer<?> frameworkDeserializer;
    protected NFTypeSerializer<?>[] topLevelSerializers;
    private final Map<String, NFTypeSerializer<?>> serializers = new HashMap();
    private final List<NFTypeSerializer<?>> orderedSerializers = new ArrayList();

    public SerializationFramework(SerializerFactory serializerFactory) {
        this.topLevelSerializers = serializerFactory.createSerializers();
        this.addSerializerTree(this.topLevelSerializers);
    }

    private void addSerializerTree(NFTypeSerializer<?> ... topLevelSerializers) {
        HashSet<String> alreadyAddedSerializers = new HashSet<String>();
        for (NFTypeSerializer<?> serializer : topLevelSerializers) {
            this.addSerializer(serializer, alreadyAddedSerializers, true);
        }
    }

    private void addSerializer(NFTypeSerializer<?> serializer, Set<String> alreadyAddedSerializers, boolean topLevelSerializer) {
        if (this.firstTimeSeeingSerializer(serializer, alreadyAddedSerializers)) {
            for (NFTypeSerializer<?> subSerializer : serializer.requiredSubSerializers()) {
                this.addSerializer(subSerializer, alreadyAddedSerializers, false);
            }
            serializer.setSerializationFramework(this);
            this.serializers.put(serializer.getName(), serializer);
            this.orderedSerializers.add(serializer);
        }
    }

    private boolean firstTimeSeeingSerializer(NFTypeSerializer<?> serializer, Set<String> alreadyAddedSerializers) {
        if (!alreadyAddedSerializers.contains(serializer.getName())) {
            alreadyAddedSerializers.add(serializer.getName());
            return true;
        }
        return false;
    }

    public FrameworkSerializer getFrameworkSerializer() {
        return this.frameworkSerializer;
    }

    public FrameworkDeserializer getFrameworkDeserializer() {
        return this.frameworkDeserializer;
    }

    public List<NFTypeSerializer<?>> getOrderedSerializers() {
        return this.orderedSerializers;
    }

    public <T> NFTypeSerializer<T> getSerializer(String typeName) {
        return this.serializers.get(typeName);
    }

    public NFTypeSerializer<?>[] getTopLevelSerializers() {
        return this.topLevelSerializers;
    }
}

