/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.serializer.common;

import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.serializer.NFDeserializationRecord;
import com.netflix.zeno.serializer.NFSerializationRecord;
import com.netflix.zeno.serializer.NFTypeSerializer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

public class DateSerializer
extends NFTypeSerializer<Date> {
    public static final String NAME = "Date";

    public DateSerializer() {
        super(NAME);
    }

    @Override
    public void doSerialize(Date value, NFSerializationRecord rec) {
        this.serializePrimitive(rec, "val", value.getTime());
    }

    @Override
    protected Date doDeserialize(NFDeserializationRecord rec) {
        return new Date(this.deserializePrimitiveLong(rec, "val"));
    }

    @Override
    protected FastBlobSchema createSchema() {
        return this.schema(this.field("val", FastBlobSchema.FieldType.LONG));
    }

    @Override
    public Collection<NFTypeSerializer<?>> requiredSubSerializers() {
        return Collections.emptyList();
    }
}

