/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.serializer.common;

import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.serializer.NFDeserializationRecord;
import com.netflix.zeno.serializer.NFSerializationRecord;
import com.netflix.zeno.serializer.NFTypeSerializer;
import java.util.Collection;
import java.util.Collections;

public class EnumSerializer<T extends Enum>
extends NFTypeSerializer<T> {
    private final Class<T> enumClazz;

    public EnumSerializer(Class<T> enumClazz) {
        super(EnumSerializer.unqualifiedClassName(enumClazz));
        this.enumClazz = enumClazz;
    }

    @Override
    public void doSerialize(T value, NFSerializationRecord rec) {
        this.serializePrimitive(rec, "value", value == null ? null : ((Enum)value).name());
    }

    @Override
    protected T doDeserialize(NFDeserializationRecord rec) {
        String value = this.deserializePrimitiveString(rec, "value");
        try {
            return Enum.valueOf(this.enumClazz, value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected FastBlobSchema createSchema() {
        return this.schema(this.field("value", FastBlobSchema.FieldType.STRING));
    }

    @Override
    public Collection<NFTypeSerializer<?>> requiredSubSerializers() {
        return Collections.emptyList();
    }

    private static String unqualifiedClassName(Class<?> clazz) {
        String qualifiedName = clazz.getCanonicalName();
        if (qualifiedName.indexOf(46) < 0) {
            return qualifiedName;
        }
        return qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
    }
}

