/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.serializer.common;

import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.serializer.NFDeserializationRecord;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.SerializationFramework;
import com.netflix.zeno.serializer.common.CollectionSerializer;
import java.util.List;

public class ListSerializer<E>
extends CollectionSerializer<E, List<E>> {
    public ListSerializer(String name, NFTypeSerializer<E> elementSerializer) {
        super(name, elementSerializer);
    }

    public ListSerializer(NFTypeSerializer<E> elementSerializer) {
        this("ListOf" + elementSerializer.getName(), elementSerializer);
    }

    @Override
    protected List<E> doDeserialize(NFDeserializationRecord rec) {
        return this.serializationFramework.getFrameworkDeserializer().deserializeList(rec, "ordinals", this.elementSerializer);
    }

    @Override
    public void setSerializationFramework(SerializationFramework framework) {
        this.serializationFramework = framework;
        this.elementSerializer.setSerializationFramework(framework);
    }

    @Override
    protected FastBlobSchema createSchema() {
        return this.schema(this.listField("ordinals", this.elementSerializer.getName()));
    }
}

