/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.serializer.common;

import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.serializer.NFDeserializationRecord;
import com.netflix.zeno.serializer.NFSerializationRecord;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.SerializationFramework;
import java.util.Collection;
import java.util.Map;

public class MapSerializer<K, V>
extends NFTypeSerializer<Map<K, V>> {
    private final NFTypeSerializer<K> keySerializer;
    private final NFTypeSerializer<V> valueSerializer;

    public MapSerializer(String schemaName, NFTypeSerializer<K> keySerializer, NFTypeSerializer<V> valueSerializer) {
        super(schemaName);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public MapSerializer(NFTypeSerializer<K> keySerializer, NFTypeSerializer<V> valueSerializer) {
        this("MapOf" + keySerializer.getName() + "To" + valueSerializer.getName(), keySerializer, valueSerializer);
    }

    @Override
    public void doSerialize(Map<K, V> map, NFSerializationRecord rec) {
        this.serializationFramework.getFrameworkSerializer().serializeMap(rec, "map", this.keySerializer.getName(), this.valueSerializer.getName(), map);
    }

    @Override
    protected Map<K, V> doDeserialize(NFDeserializationRecord rec) {
        return this.serializationFramework.getFrameworkDeserializer().deserializeMap(rec, "map", this.keySerializer, this.valueSerializer);
    }

    @Override
    protected FastBlobSchema createSchema() {
        return this.schema(this.mapField("map", this.keySerializer.getName(), this.valueSerializer.getName()));
    }

    @Override
    public Collection<NFTypeSerializer<?>> requiredSubSerializers() {
        return this.serializers(this.keySerializer, this.valueSerializer);
    }

    @Override
    public void setSerializationFramework(SerializationFramework framework) {
        this.serializationFramework = framework;
        this.keySerializer.setSerializationFramework(framework);
        this.valueSerializer.setSerializationFramework(framework);
    }
}

