/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.serializer.common;

import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.serializer.NFDeserializationRecord;
import com.netflix.zeno.serializer.NFSerializationRecord;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.SerializationFramework;
import com.netflix.zeno.serializer.common.CollectionSerializer;
import java.util.Set;

public class SetSerializer<E>
extends CollectionSerializer<E, Set<E>> {
    public SetSerializer(String schemaName, NFTypeSerializer<E> elementSerializer) {
        super(schemaName, elementSerializer);
    }

    public SetSerializer(NFTypeSerializer<E> elementSerializer) {
        this("SetOf" + elementSerializer.getName(), elementSerializer);
    }

    @Override
    public void doSerialize(Set<E> list, NFSerializationRecord rec) {
        this.serializationFramework.getFrameworkSerializer().serializeSet(rec, "ordinals", this.elementSerializer.getName(), list);
    }

    @Override
    protected Set<E> doDeserialize(NFDeserializationRecord rec) {
        return this.serializationFramework.getFrameworkDeserializer().deserializeSet(rec, "ordinals", this.elementSerializer);
    }

    @Override
    public void setSerializationFramework(SerializationFramework framework) {
        this.serializationFramework = framework;
        this.elementSerializer.setSerializationFramework(framework);
    }

    @Override
    protected FastBlobSchema createSchema() {
        return this.schema(this.setField("ordinals", this.elementSerializer.getName()));
    }
}

