/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util;

import com.netflix.zeno.util.collections.MinimizedUnmodifiableCollections;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class CollectionUnwrapper {
    private static final Class<?> unmodifiableCollectionClass = CollectionUnwrapper.getInnerClass(Collections.class, "UnmodifiableCollection");
    private static final Field unmodifiableCollectionField = CollectionUnwrapper.getField(unmodifiableCollectionClass, "c");
    private static final Class<?> unmodifiableMapClass = CollectionUnwrapper.getInnerClass(Collections.class, "UnmodifiableMap");
    private static final Field unmodifiableMapField = CollectionUnwrapper.getField(unmodifiableMapClass, "m");

    private static Class<?> getInnerClass(Class<?> fromClass, String className) {
        for (Class<?> c : fromClass.getDeclaredClasses()) {
            if (!c.getSimpleName().equals(className)) continue;
            return c;
        }
        return null;
    }

    private static Field getField(Class<?> fromClass, String fieldName) {
        try {
            Field f = fromClass.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T unwrap(Object obj) {
        if (obj instanceof Collection) {
            if (((Collection)obj).isEmpty()) {
                if (obj instanceof List) {
                    return (T)Collections.EMPTY_LIST;
                }
                if (obj instanceof Set) {
                    return (T)Collections.EMPTY_SET;
                }
            }
            if (unmodifiableCollectionClass.isInstance(obj)) {
                return CollectionUnwrapper.unwrap(obj, unmodifiableCollectionClass, unmodifiableCollectionField);
            }
        } else if (obj instanceof Map) {
            if (((Map)obj).isEmpty()) {
                if (obj instanceof SortedMap) {
                    return (T)MinimizedUnmodifiableCollections.EMPTY_SORTED_MAP;
                }
                return (T)Collections.EMPTY_MAP;
            }
            if (unmodifiableMapClass.isInstance(obj)) {
                return CollectionUnwrapper.unwrap(obj, unmodifiableMapClass, unmodifiableMapField);
            }
        }
        return (T)obj;
    }

    private static <T> T unwrap(Object obj, Class<?> clazz, Field field) {
        try {
            while (clazz.isInstance(obj = field.get(obj))) {
            }
            return (T)obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

