/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SimultaneousExecutor
extends ThreadPoolExecutor {
    private static final String DEFAULT_THREAD_NAME = "zeno-simultaneous-executor";

    public SimultaneousExecutor() {
        this(2.5);
    }

    public SimultaneousExecutor(double threadsPerCpu) {
        this(threadsPerCpu, DEFAULT_THREAD_NAME);
    }

    public SimultaneousExecutor(double threadsPerCpu, String threadName) {
        this((int)((double)Runtime.getRuntime().availableProcessors() * threadsPerCpu), threadName);
    }

    public SimultaneousExecutor(int numThreads) {
        this(numThreads, DEFAULT_THREAD_NAME);
    }

    public SimultaneousExecutor(int numThreads, final String threadName) {
        super(numThreads, numThreads, (long)numThreads, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, threadName);
                t.setDaemon(true);
                return t;
            }
        });
    }

    public void awaitUninterruptibly() {
        this.shutdown();
        while (!this.isTerminated()) {
            try {
                this.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

