/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections;

import com.netflix.zeno.util.collections.CollectionImplementation;
import com.netflix.zeno.util.collections.builder.Builders;
import com.netflix.zeno.util.collections.builder.ListBuilder;
import com.netflix.zeno.util.collections.builder.MapBuilder;
import com.netflix.zeno.util.collections.builder.SetBuilder;
import com.netflix.zeno.util.collections.impl.BinarySearchArrayHashMap;
import com.netflix.zeno.util.collections.impl.BinarySearchArrayIndexedHashMap;
import com.netflix.zeno.util.collections.impl.BinarySearchArrayIndexedSet;
import com.netflix.zeno.util.collections.impl.BinarySearchArrayMap;
import com.netflix.zeno.util.collections.impl.BinarySearchArraySet;
import com.netflix.zeno.util.collections.impl.ImmutableArrayList;
import com.netflix.zeno.util.collections.impl.NetflixCollections;
import com.netflix.zeno.util.collections.impl.OpenAddressingArraySet;
import com.netflix.zeno.util.collections.impl.OpenAddressingHashMap;
import com.netflix.zeno.util.collections.impl.OpenAddressingSortedHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class MinimizedUnmodifiableCollections {
    public static final SortedMap EMPTY_SORTED_MAP = Collections.unmodifiableSortedMap(new TreeMap());
    private final CollectionImplementation implementation;

    public MinimizedUnmodifiableCollections(CollectionImplementation implementation) {
        this.implementation = implementation;
    }

    public <K, V> SortedMap<K, V> emptySortedMap() {
        return EMPTY_SORTED_MAP;
    }

    public <K, V> Map<K, V> minimizeMap(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public <K, V> SortedMap<K, V> minimizeSortedMap(SortedMap<K, V> map) {
        if (map.isEmpty()) {
            return NetflixCollections.emptySortedMap();
        }
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return NetflixCollections.singletonSortedMap(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public <E> Set<E> minimizeSet(Set<E> set) {
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        if (set.size() == 1) {
            return Collections.singleton(set.iterator().next());
        }
        return set;
    }

    public <E> List<E> minimizeList(List<E> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.iterator().next());
        }
        return list;
    }

    public <E> ListBuilder<E> createListBuilder() {
        switch (this.implementation) {
            case COMPACT_BINARYSEARCH: 
            case COMPACT_BINARYSEARCH_INDEXED: 
            case COMPACT_OPENADDRESS: {
                return new ImmutableArrayList();
            }
        }
        return new Builders.ArrayListBuilder();
    }

    public <E> SetBuilder<E> createSetBuilder() {
        switch (this.implementation) {
            case COMPACT_BINARYSEARCH: {
                return new BinarySearchArraySet();
            }
            case COMPACT_BINARYSEARCH_INDEXED: {
                return new BinarySearchArrayIndexedSet();
            }
            case COMPACT_OPENADDRESS: {
                return new OpenAddressingArraySet();
            }
        }
        return new Builders.HashSetBuilder();
    }

    public <K, V> MapBuilder<K, V> createMapBuilder() {
        switch (this.implementation) {
            case COMPACT_BINARYSEARCH: {
                return new BinarySearchArrayHashMap();
            }
            case COMPACT_BINARYSEARCH_INDEXED: {
                return new BinarySearchArrayIndexedHashMap();
            }
            case COMPACT_OPENADDRESS: {
                return new OpenAddressingHashMap();
            }
        }
        return new Builders.HashMapBuilder();
    }

    public <K, V> MapBuilder<K, V> createSortedMapBuilder() {
        switch (this.implementation) {
            case COMPACT_BINARYSEARCH: 
            case COMPACT_BINARYSEARCH_INDEXED: {
                return new BinarySearchArrayMap();
            }
            case COMPACT_OPENADDRESS: {
                return new OpenAddressingSortedHashMap();
            }
        }
        return new Builders.TreeMapBuilder();
    }
}

