/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.algorithms;

import com.netflix.zeno.util.collections.algorithms.Sortable;
import java.util.Comparator;

public class ArrayQuickSort {
    private static int nextPivot = 0;

    public static <E> void sort(Sortable<E> arr, Comparator<E> comparator) {
        nextPivot = 0;
        ArrayQuickSort.quicksort(arr, comparator, 0, arr.size() - 1);
    }

    private static <E> void quicksort(Sortable<E> arr, Comparator<E> comparator, int from, int to) {
        if (to > from) {
            int pivotIndex = ArrayQuickSort.findPivot(from, to);
            pivotIndex = ArrayQuickSort.pivot(arr, comparator, from, to, pivotIndex);
            ArrayQuickSort.quicksort(arr, comparator, from, pivotIndex - 1);
            ArrayQuickSort.quicksort(arr, comparator, pivotIndex + 1, to);
        }
    }

    private static <E> int findPivot(int from, int to) {
        return ++nextPivot % (to - from + 1) + from;
    }

    private static <E> int pivot(Sortable<E> arr, Comparator<E> comparator, int from, int to, int pivotIndex) {
        E pivotValue = arr.at(pivotIndex);
        arr.swap(pivotIndex, to);
        for (int i = from; i < to; ++i) {
            if (comparator.compare(arr.at(i), pivotValue) > 0) continue;
            arr.swap(i, from);
            ++from;
        }
        arr.swap(from, to);
        return from;
    }
}

