/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.algorithms;

import com.netflix.zeno.util.collections.algorithms.Sortable;
import java.util.Comparator;

public class BinarySearch {
    private static void rangeCheck(int length, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > length) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public static <T> int binarySearch(Sortable<T> a, int fromIndex, int toIndex, T key, Comparator<? super T> c) {
        BinarySearch.rangeCheck(a.size(), fromIndex, toIndex);
        return BinarySearch.binarySearch0(a, fromIndex, toIndex, key, c);
    }

    public static <T> int binarySearch(Sortable<T> a, T key, Comparator<? super T> c) {
        return BinarySearch.binarySearch(a, 0, a.size(), key, c);
    }

    private static <T> int binarySearch0(Sortable<T> a, int fromIndex, int toIndex, T key, Comparator<? super T> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = a.at(mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

