/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.builder;

import com.netflix.zeno.util.collections.builder.ListBuilder;
import com.netflix.zeno.util.collections.builder.MapBuilder;
import com.netflix.zeno.util.collections.builder.SetBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class Builders {

    public static class HashSetBuilder<E>
    implements SetBuilder<E> {
        Set<E> set;

        @Override
        public void builderInit(int size) {
            this.set = new HashSet(size);
        }

        @Override
        public void builderSet(int index, E element) {
            this.set.add(element);
        }

        @Override
        public Set<E> builderFinish() {
            return this.set;
        }
    }

    public static class ArrayListBuilder<E>
    implements ListBuilder<E> {
        List<E> list;

        @Override
        public void builderInit(int size) {
            this.list = new ArrayList(size);
        }

        @Override
        public void builderSet(int index, E element) {
            this.list.add(element);
        }

        @Override
        public List<E> builderFinish() {
            return this.list;
        }
    }

    public static class TreeMapBuilder<K, V>
    implements MapBuilder<K, V> {
        TreeMap<K, V> map;

        @Override
        public void builderInit(int size) {
            this.map = new TreeMap();
        }

        @Override
        public void builderPut(int index, K key, V value) {
            this.map.put(key, value);
        }

        @Override
        public SortedMap<K, V> builderFinish() {
            return this.map;
        }
    }

    public static class HashMapBuilder<K, V>
    implements MapBuilder<K, V> {
        HashMap<K, V> map;

        @Override
        public void builderInit(int size) {
            this.map = new HashMap(size);
        }

        @Override
        public void builderPut(int index, K key, V value) {
            this.map.put(key, value);
        }

        @Override
        public Map<K, V> builderFinish() {
            return this.map;
        }
    }
}

