/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.heapfriendly;

import com.netflix.zeno.util.collections.heapfriendly.HeapFriendlyMapArrayRecycler;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class AbstractHeapFriendlyMap<K, V>
extends AbstractMap<K, V> {
    protected Object segmentedGet(Object[][] segmentedArray, int bucket) {
        int arrayIndex = bucket / 4096;
        int elementIndex = bucket % 4096;
        return segmentedArray[arrayIndex][elementIndex];
    }

    protected void segmentedSet(Object[][] segmentedArray, int bucket, Object value) {
        int arrayIndex = bucket / 4096;
        int elementIndex = bucket % 4096;
        segmentedArray[arrayIndex][elementIndex] = value;
    }

    public abstract void releaseObjectArrays();

    protected void releaseObjectArrays(Object[][] segmentedArray, HeapFriendlyMapArrayRecycler recycler) {
        for (int i = 0; i < segmentedArray.length; ++i) {
            recycler.returnObjectArray(segmentedArray[i]);
        }
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("VMS error: Cannot remove items from a HeapFriendlyMap");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("VMS error: HeapFriendlyMap cannot be added to with a specified key.  Please use put(V value).");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("VMS error: Cannot clear a HeapFriendlyMap.");
    }

    protected static abstract class AbstractHeapFriendlyMapEntry<K, V>
    implements Map.Entry<K, V> {
        protected AbstractHeapFriendlyMapEntry() {
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("Cannot set value for HeapFriendlyMap Entry");
        }

        @Override
        public boolean equals(Object o) {
            if (Map.Entry.class.isAssignableFrom(o.getClass())) {
                Map.Entry other = (Map.Entry)o;
                return (this.getKey() == null ? other.getKey() == null : this.getKey().equals(other.getKey())) && (this.getValue() == null ? other.getValue() == null : this.getValue().equals(other.getValue()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    protected class HeapFriendlyMapIterator<T>
    implements Iterator<T> {
        protected final Object[][] segmentedArray;
        protected final int numBuckets;
        protected int current = -1;

        protected HeapFriendlyMapIterator(Object[][] segmentedArray, int numBuckets) {
            this.segmentedArray = segmentedArray;
            this.numBuckets = numBuckets;
            this.moveToNext();
        }

        @Override
        public boolean hasNext() {
            return this.current < this.numBuckets;
        }

        @Override
        public T next() {
            if (this.current >= this.numBuckets) {
                throw new NoSuchElementException();
            }
            Object val = AbstractHeapFriendlyMap.this.segmentedGet(this.segmentedArray, this.current);
            this.moveToNext();
            return (T)val;
        }

        protected void moveToNext() {
            ++this.current;
            while (this.current < this.numBuckets && AbstractHeapFriendlyMap.this.segmentedGet(this.segmentedArray, this.current) == null) {
                ++this.current;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("VMS error:  Cannot remove from a HeapFriendlyMapIterator");
        }
    }
}

