/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.heapfriendly;

import com.netflix.zeno.util.collections.heapfriendly.AbstractHeapFriendlyMap;
import com.netflix.zeno.util.collections.heapfriendly.HeapFriendlyMapArrayRecycler;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class HeapFriendlyDerivableKeyHashMap<K, V>
extends AbstractHeapFriendlyMap<K, V> {
    private final Object[][] values;
    private final int numBuckets;
    private final int maxSize;
    private final HeapFriendlyMapArrayRecycler recycler;
    private int size;

    protected HeapFriendlyDerivableKeyHashMap(int numEntries) {
        this(numEntries, HeapFriendlyMapArrayRecycler.get());
    }

    protected HeapFriendlyDerivableKeyHashMap(int numEntries, HeapFriendlyMapArrayRecycler recycler) {
        int arraySize = numEntries * 10 / 7;
        arraySize = 1 << 32 - Integer.numberOfLeadingZeros(arraySize);
        this.numBuckets = arraySize = Math.max(arraySize, 4096);
        this.maxSize = numEntries;
        this.recycler = recycler;
        this.values = this.createSegmentedObjectArray(arraySize);
    }

    private Object[][] createSegmentedObjectArray(int arraySize) {
        int numArrays = arraySize / 4096;
        Object[][] segmentedArray = new Object[numArrays][];
        for (int i = 0; i < numArrays; ++i) {
            segmentedArray[i] = this.recycler.getObjectArray();
        }
        return segmentedArray;
    }

    public V put(V value) {
        if (this.size == this.maxSize && !this.containsKey(this.deriveKey(value))) {
            throw new UnsupportedOperationException("Cannot add more elements than " + this.maxSize);
        }
        K key = this.deriveKey(value);
        if (key == null) {
            throw new NullPointerException("Null keys not allowed in HeapFriendlyDerivableKeyHashMap");
        }
        int hashCode = this.rehash(key.hashCode());
        int bucket = hashCode & this.numBuckets - 1;
        Object foundValue = this.segmentedGet(this.values, bucket);
        while (foundValue != null && !this.deriveKey(foundValue).equals(this.deriveKey(value))) {
            bucket = bucket + 1 & this.numBuckets - 1;
            foundValue = this.segmentedGet(this.values, bucket);
        }
        this.segmentedSet(this.values, bucket, value);
        if (foundValue == null) {
            ++this.size;
        }
        return (V)foundValue;
    }

    @Override
    public V get(Object key) {
        int hashCode = this.rehash(key.hashCode());
        int bucket = hashCode & this.numBuckets - 1;
        Object foundValue = this.segmentedGet(this.values, bucket);
        while (foundValue != null) {
            if (this.deriveKey(foundValue).equals(key)) {
                return (V)foundValue;
            }
            bucket = bucket + 1 & this.numBuckets - 1;
            foundValue = this.segmentedGet(this.values, bucket);
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        return this.get(this.deriveKey(value)) != null;
    }

    @Override
    public void releaseObjectArrays() {
        this.releaseObjectArrays(this.values, this.recycler);
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new AbstractHeapFriendlyMap.HeapFriendlyMapIterator<K>(HeapFriendlyDerivableKeyHashMap.this.values, HeapFriendlyDerivableKeyHashMap.this.numBuckets){

                    @Override
                    public K next() {
                        Object key = HeapFriendlyDerivableKeyHashMap.this.deriveKey(HeapFriendlyDerivableKeyHashMap.this.segmentedGet(HeapFriendlyDerivableKeyHashMap.this.values, this.current));
                        this.moveToNext();
                        return key;
                    }
                };
            }

            @Override
            public boolean contains(Object value) {
                return HeapFriendlyDerivableKeyHashMap.this.containsKey(value);
            }

            @Override
            public int size() {
                return HeapFriendlyDerivableKeyHashMap.this.size;
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractSet<V>(){

            @Override
            public Iterator<V> iterator() {
                return new AbstractHeapFriendlyMap.HeapFriendlyMapIterator(HeapFriendlyDerivableKeyHashMap.this, HeapFriendlyDerivableKeyHashMap.this.values, HeapFriendlyDerivableKeyHashMap.this.numBuckets);
            }

            @Override
            public int size() {
                return HeapFriendlyDerivableKeyHashMap.this.size;
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new AbstractHeapFriendlyMap.HeapFriendlyMapIterator<Map.Entry<K, V>>(HeapFriendlyDerivableKeyHashMap.this.values, HeapFriendlyDerivableKeyHashMap.this.numBuckets){

                    @Override
                    public Map.Entry<K, V> next() {
                        if (this.current >= this.numBuckets) {
                            throw new NoSuchElementException();
                        }
                        DerivableKeyHashMapEntry entry = new DerivableKeyHashMapEntry(HeapFriendlyDerivableKeyHashMap.this.segmentedGet(this.segmentedArray, this.current));
                        this.moveToNext();
                        return entry;
                    }
                };
            }

            @Override
            public int size() {
                return HeapFriendlyDerivableKeyHashMap.this.size;
            }
        };
    }

    protected abstract K deriveKey(V var1);

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("VMS error: HeapFriendlyDerivableKeyMap cannot be added to with a specified key.  Please use put(V value).");
    }

    private int rehash(int hash) {
        hash = ~hash + (hash << 15);
        hash ^= hash >>> 12;
        hash += hash << 2;
        hash ^= hash >>> 4;
        hash *= 2057;
        hash ^= hash >>> 16;
        return hash;
    }

    private class DerivableKeyHashMapEntry
    extends AbstractHeapFriendlyMap.AbstractHeapFriendlyMapEntry<K, V> {
        private final V value;

        DerivableKeyHashMapEntry(V value) {
            this.value = value;
        }

        @Override
        public K getKey() {
            return HeapFriendlyDerivableKeyHashMap.this.deriveKey(this.value);
        }

        @Override
        public V getValue() {
            return this.value;
        }
    }
}

