/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.heapfriendly;

import com.netflix.zeno.util.collections.heapfriendly.AbstractHeapFriendlyMap;
import com.netflix.zeno.util.collections.heapfriendly.HeapFriendlyMapArrayRecycler;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HeapFriendlyHashMap<K, V>
extends AbstractHeapFriendlyMap<K, V> {
    private final Object[][] keys;
    private final Object[][] values;
    private final int numBuckets;
    private final int maxSize;
    private final HeapFriendlyMapArrayRecycler recycler;
    private int size;

    public HeapFriendlyHashMap(int numEntries) {
        this(numEntries, HeapFriendlyMapArrayRecycler.get());
    }

    public HeapFriendlyHashMap(int numEntries, HeapFriendlyMapArrayRecycler recycler) {
        int arraySize = numEntries * 10 / 7;
        arraySize = 1 << 32 - Integer.numberOfLeadingZeros(arraySize);
        this.numBuckets = arraySize = Math.max(arraySize, 4096);
        this.maxSize = numEntries;
        this.recycler = recycler;
        this.keys = this.createSegmentedObjectArray(arraySize);
        this.values = this.createSegmentedObjectArray(arraySize);
    }

    private Object[][] createSegmentedObjectArray(int arraySize) {
        int numArrays = arraySize / 4096;
        Object[][] segmentedArray = new Object[numArrays][];
        for (int i = 0; i < numArrays; ++i) {
            segmentedArray[i] = this.recycler.getObjectArray();
        }
        return segmentedArray;
    }

    @Override
    public V put(K key, V value) {
        if (this.size >= this.maxSize && !this.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot add more elements than " + this.maxSize);
        }
        if (key == null || value == null) {
            throw new NullPointerException("Null keys / values not supported in HeapFriendlyHashMap");
        }
        int hashCode = this.rehash(key.hashCode());
        int bucket = hashCode & this.numBuckets - 1;
        Object foundKey = this.segmentedGet(this.keys, bucket);
        while (foundKey != null && !foundKey.equals(key)) {
            bucket = bucket + 1 & this.numBuckets - 1;
            foundKey = this.segmentedGet(this.keys, bucket);
        }
        Object foundValue = this.segmentedGet(this.values, bucket);
        this.segmentedSet(this.keys, bucket, key);
        this.segmentedSet(this.values, bucket, value);
        if (foundValue == null) {
            ++this.size;
        }
        return (V)foundValue;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        int hashCode = this.rehash(key.hashCode());
        int bucket = hashCode & this.numBuckets - 1;
        Object foundKey = this.segmentedGet(this.keys, bucket);
        while (foundKey != null) {
            if (foundKey.equals(key)) {
                return (V)this.segmentedGet(this.values, bucket);
            }
            bucket = bucket + 1 & this.numBuckets - 1;
            foundKey = this.segmentedGet(this.keys, bucket);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        return this.get(key) != null;
    }

    private int rehash(int hash) {
        hash = ~hash + (hash << 15);
        hash ^= hash >>> 12;
        hash += hash << 2;
        hash ^= hash >>> 4;
        hash *= 2057;
        hash ^= hash >>> 16;
        return hash;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        for (V foundValue : this.values()) {
            if (!foundValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new AbstractHeapFriendlyMap.HeapFriendlyMapIterator(HeapFriendlyHashMap.this, HeapFriendlyHashMap.this.keys, HeapFriendlyHashMap.this.numBuckets);
            }

            @Override
            public boolean contains(Object value) {
                return HeapFriendlyHashMap.this.containsKey(value);
            }

            @Override
            public int size() {
                return HeapFriendlyHashMap.this.size;
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractSet<V>(){

            @Override
            public Iterator<V> iterator() {
                return new AbstractHeapFriendlyMap.HeapFriendlyMapIterator(HeapFriendlyHashMap.this, HeapFriendlyHashMap.this.values, HeapFriendlyHashMap.this.numBuckets);
            }

            @Override
            public int size() {
                return HeapFriendlyHashMap.this.size;
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new AbstractHeapFriendlyMap.HeapFriendlyMapIterator<Map.Entry<K, V>>(HeapFriendlyHashMap.this.keys, HeapFriendlyHashMap.this.numBuckets){

                    @Override
                    public Map.Entry<K, V> next() {
                        if (this.current >= this.numBuckets) {
                            throw new NoSuchElementException();
                        }
                        Object key = HeapFriendlyHashMap.this.segmentedGet(this.segmentedArray, this.current);
                        Entry<Object, Object> entry = new Entry<Object, Object>(key, HeapFriendlyHashMap.this.segmentedGet(HeapFriendlyHashMap.this.values, this.current));
                        this.moveToNext();
                        return entry;
                    }
                };
            }

            @Override
            public int size() {
                return HeapFriendlyHashMap.this.size;
            }
        };
    }

    @Override
    public void releaseObjectArrays() {
        this.releaseObjectArrays(this.keys, this.recycler);
        this.releaseObjectArrays(this.values, this.recycler);
    }

    private static class Entry<K, V>
    extends AbstractHeapFriendlyMap.AbstractHeapFriendlyMapEntry<K, V> {
        private final K key;
        private final V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }
    }
}

