/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.heapfriendly;

import java.util.Arrays;
import java.util.LinkedList;

public class HeapFriendlyMapArrayRecycler {
    public static final int INDIVIDUAL_OBJECT_ARRAY_SIZE = 4096;
    private LinkedList<Object[]> currentCycleObjects = new LinkedList();
    private LinkedList<Object[]> nextCycleObjects = new LinkedList();
    private static final HeapFriendlyMapArrayRecycler theInstance = new HeapFriendlyMapArrayRecycler();

    public Object[] getObjectArray() {
        if (!this.currentCycleObjects.isEmpty()) {
            return this.currentCycleObjects.removeFirst();
        }
        return new Object[4096];
    }

    public void returnObjectArray(Object[] toReturn) {
        this.nextCycleObjects.addLast(toReturn);
    }

    public void clearNextCycleObjectArrays() {
        for (Object[] arr : this.nextCycleObjects) {
            Arrays.fill(arr, null);
        }
    }

    public void swapCycleObjectArrays() {
        LinkedList<Object[]> temp = this.currentCycleObjects;
        this.currentCycleObjects = this.nextCycleObjects;
        this.nextCycleObjects = temp;
    }

    public void clear() {
        this.currentCycleObjects.clear();
        this.nextCycleObjects.clear();
    }

    public static HeapFriendlyMapArrayRecycler get() {
        return theInstance;
    }
}

