/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.heapfriendly;

import com.netflix.zeno.util.collections.heapfriendly.HeapFriendlyHashMap;
import com.netflix.zeno.util.collections.heapfriendly.HeapFriendlyMapArrayRecycler;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class PhasedHeapFriendlyHashMap<K, V>
implements Map<K, V> {
    private final HeapFriendlyMapArrayRecycler recycler = new HeapFriendlyMapArrayRecycler();
    private HeapFriendlyHashMap<K, V> currentMap = new HeapFriendlyHashMap(0, this.recycler);
    private HeapFriendlyHashMap<K, V> nextMap;

    @Override
    public int size() {
        return this.currentMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.currentMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.currentMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.currentMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.currentMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (this.nextMap != null) {
            return this.nextMap.put(key, value);
        }
        throw new IllegalStateException("PhasedHeapFriendlyHashMap.put(K, V) only usable when in the data swap phase");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("PhasedHeapFriendlyHashMap.remove(Object) not supported");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("PhasedHeapFriendlyHashMap.putAll(Map) not supported, please use PhasedHeapFriendlyHashMap.put(Object) instead");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("PhasedHeapFriendlyHashMap.clear() not supported");
    }

    @Override
    public Set<K> keySet() {
        return this.currentMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.currentMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.currentMap.entrySet();
    }

    public void beginDataSwapPhase(int numOfNewEntries) {
        if (this.nextMap != null) {
            throw new IllegalStateException("Cannot call PhasedHeapFriendlyHashMap.beginDataSwapPhase(int), already in data swap phase");
        }
        this.recycler.swapCycleObjectArrays();
        this.nextMap = new HeapFriendlyHashMap(numOfNewEntries, this.recycler);
    }

    public void endDataSwapPhase() {
        if (this.nextMap == null) {
            throw new IllegalStateException("Cannot call PhasedHeapFriendlyHashMap.endDataSwapPhase(), not currently in data swap phase");
        }
        HeapFriendlyHashMap<K, V> temp = this.currentMap;
        this.currentMap = this.nextMap;
        this.nextMap = null;
        temp.releaseObjectArrays();
        this.recycler.clearNextCycleObjectArrays();
    }
}

