/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.impl;

import com.netflix.zeno.util.collections.builder.MapBuilder;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class AbstractArrayMap<K, V>
implements Map<K, V>,
MapBuilder<K, V> {
    protected static final Object undefined = new Object();

    public AbstractArrayMap() {
    }

    public AbstractArrayMap(AbstractArrayMap<K, V> map, int start, int end) {
        this.builderInit(end - start);
        for (int i = start; i < end; ++i) {
            this.builderPut(i - start, map.key(i), map.value(i));
        }
        this.builderFinish();
    }

    public abstract Object getUndefined(Object var1);

    @Override
    public abstract int size();

    protected abstract K key(int var1);

    protected abstract V value(int var1);

    @Override
    public abstract void builderInit(int var1);

    @Override
    public abstract void builderPut(int var1, K var2, V var3);

    @Override
    public abstract Map<K, V> builderFinish();

    public void setMap(Map<K, V> map) {
        this.builderInit(map.size());
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.builderPut(i++, entry.getKey(), entry.getValue());
        }
        this.builderFinish();
    }

    public void setMap(Map.Entry<K, V>[] entries) {
        this.builderInit(entries.length);
        int i = 0;
        for (Map.Entry<K, V> entry : entries) {
            this.builderPut(i++, entry.getKey(), entry.getValue());
        }
        this.builderFinish();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V get(Object key) {
        Object result = this.getUndefined(key);
        if (result == undefined) {
            return null;
        }
        return (V)result;
    }

    @Override
    public boolean containsKey(Object key) {
        return undefined != this.getUndefined(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.value(i) == value) {
                return true;
            }
            if (value == null || !value.equals(this.value(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : this.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new ValueCollection();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    protected int hashCode(Object o) {
        return o == null ? 0 : this.rehash(o.hashCode());
    }

    protected int rehash(int hash) {
        return hash;
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return AbstractArrayMap.this.size();
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        int cursor;
        int lastRet = -1;

        private EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != AbstractArrayMap.this.size();
        }

        @Override
        public Map.Entry<K, V> next() {
            int i = this.cursor;
            if (i >= AbstractArrayMap.this.size()) {
                throw new NoSuchElementException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return new AbstractMap.SimpleImmutableEntry(AbstractArrayMap.this.key(this.lastRet), AbstractArrayMap.this.value(this.lastRet));
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                AbstractArrayMap.this.remove(AbstractArrayMap.this.key(this.lastRet));
                this.cursor = this.lastRet;
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class ValueCollection<E>
    extends AbstractCollection<E> {
        private ValueCollection() {
        }

        @Override
        public Iterator<E> iterator() {
            return new KeyValueIterator(false);
        }

        @Override
        public int size() {
            return AbstractArrayMap.this.size();
        }
    }

    private class KeySet<E>
    extends AbstractSet<E> {
        private KeySet() {
        }

        @Override
        public Iterator<E> iterator() {
            return new KeyValueIterator(true);
        }

        @Override
        public boolean contains(Object o) {
            return AbstractArrayMap.this.containsKey(o);
        }

        @Override
        public int size() {
            return AbstractArrayMap.this.size();
        }
    }

    private class KeyValueIterator<E>
    implements Iterator<E> {
        boolean key;
        int cursor;
        int lastRet = -1;

        public KeyValueIterator(boolean key) {
            this.key = key;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != AbstractArrayMap.this.size();
        }

        @Override
        public E next() {
            int i = this.cursor;
            if (i >= AbstractArrayMap.this.size()) {
                throw new NoSuchElementException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return (E)(this.key ? AbstractArrayMap.this.key(this.lastRet) : AbstractArrayMap.this.value(this.lastRet));
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                AbstractArrayMap.this.remove(AbstractArrayMap.this.key(this.lastRet));
                this.cursor = this.lastRet;
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

