/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.impl;

import com.netflix.zeno.util.collections.builder.SetBuilder;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractArraySet<E>
extends AbstractSet<E>
implements SetBuilder<E> {
    public AbstractArraySet() {
    }

    public AbstractArraySet(Collection<E> from) {
        this.setElements(from);
    }

    protected void setElements(Collection<E> from) {
        this.builderInit(from.size());
        int i = 0;
        for (E element : from) {
            this.builderSet(i++, element);
        }
        this.builderFinish();
    }

    @Override
    public abstract int size();

    @Override
    public abstract boolean contains(Object var1);

    @Override
    public Iterator<E> iterator() {
        return new SetIterator();
    }

    protected void removeElement(int index) {
        throw new UnsupportedOperationException();
    }

    protected abstract E element(int var1);

    protected int hashCode(Object o) {
        return o == null ? 0 : this.rehash(o.hashCode());
    }

    protected int rehash(int hash) {
        return hash;
    }

    private class SetIterator
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;

        private SetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != AbstractArraySet.this.size();
        }

        @Override
        public E next() {
            int i = this.cursor;
            if (i >= AbstractArraySet.this.size()) {
                throw new NoSuchElementException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return AbstractArraySet.this.element(this.lastRet);
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                AbstractArraySet.this.removeElement(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

