/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.impl;

import com.netflix.zeno.util.collections.Comparators;
import com.netflix.zeno.util.collections.algorithms.BinarySearch;
import com.netflix.zeno.util.collections.algorithms.Sortable;
import com.netflix.zeno.util.collections.builder.MapBuilder;
import com.netflix.zeno.util.collections.impl.AbstractArrayMap;
import com.netflix.zeno.util.collections.impl.BinarySearchArrayMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;

public abstract class AbstractArraySortedMap<K, V>
extends AbstractArrayMap<K, V>
implements SortedMap<K, V>,
Sortable<K>,
Comparable<AbstractArrayMap<K, V>>,
MapBuilder<K, V> {
    public AbstractArraySortedMap() {
    }

    public AbstractArraySortedMap(AbstractArrayMap<K, V> map, int start, int end) {
        super(map, start, end);
    }

    @Override
    public abstract Comparator<K> comparator();

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        int start = 0;
        if (fromKey != null) {
            start = BinarySearch.binarySearch(this, fromKey, this.comparator());
            int i = start = start >= 0 ? start : -start - 1;
            while (i >= 0 && i < this.size() && this.comparator().compare(this.key(i), fromKey) >= 0) {
                start = i--;
            }
        }
        int end = this.size();
        if (toKey != null) {
            end = BinarySearch.binarySearch(this, toKey, this.comparator());
            int i = end = end >= 0 ? end : -end - 1;
            while (i >= 0 && i < this.size() && this.comparator().compare(this.key(i), toKey) < 0) {
                end = i++;
            }
        }
        start = Math.max(start, 0);
        end = Math.min(end, this.size());
        return this.newMap(start, end);
    }

    public abstract SortedMap<K, V> newMap(int var1, int var2);

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.subMap(null, toKey);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return this.subMap(fromKey, null);
    }

    @Override
    public K firstKey() {
        return this.key(0);
    }

    @Override
    public K lastKey() {
        return this.key(this.size() - 1);
    }

    @Override
    public K at(int index) {
        return this.key(index);
    }

    @Override
    public abstract void swap(int var1, int var2);

    @Override
    public int compareTo(AbstractArrayMap<K, V> o) {
        Map.Entry otherEntry;
        Map.Entry selfEntry;
        int valueCompare;
        if (o == this) {
            return 0;
        }
        if (!(o instanceof BinarySearchArrayMap)) {
            return this.getClass().getCanonicalName().compareTo(o.getClass().getCanonicalName());
        }
        AbstractArrayMap<K, V> m = o;
        if (this.size() == 0 && m.size() == 0) {
            return 0;
        }
        Iterator itSelf = this.entrySet().iterator();
        Iterator itOther = m.entrySet().iterator();
        do {
            boolean selfNext = itSelf.hasNext();
            boolean otherNext = itOther.hasNext();
            if (!selfNext && !otherNext) {
                return 0;
            }
            if (!selfNext && otherNext) {
                return -1;
            }
            if (selfNext && !otherNext) {
                return 1;
            }
            selfEntry = itSelf.next();
            otherEntry = itOther.next();
            int keyCompare = this.comparator().compare(selfEntry.getKey(), otherEntry.getKey());
            if (keyCompare == 0) continue;
            return keyCompare;
        } while ((valueCompare = Comparators.comparableComparator().compare(selfEntry.getValue(), otherEntry.getValue())) == 0);
        return valueCompare;
    }
}

