/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.impl;

import com.netflix.zeno.util.collections.Comparators;
import com.netflix.zeno.util.collections.algorithms.ArrayQuickSort;
import com.netflix.zeno.util.collections.algorithms.Sortable;
import com.netflix.zeno.util.collections.impl.AbstractArrayMap;
import com.netflix.zeno.util.collections.impl.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class BinarySearchArrayIndexedHashMap<K, V>
extends AbstractArrayMap<K, V>
implements Sortable<Integer> {
    protected int[] hashes = null;
    protected Object[] keysAndValues = null;

    public BinarySearchArrayIndexedHashMap() {
        this.setMap(Collections.emptyMap());
    }

    public BinarySearchArrayIndexedHashMap(Map<K, V> map) {
        this.setMap(map);
    }

    public BinarySearchArrayIndexedHashMap(Map.Entry<K, V>[] entries) {
        this.setMap(entries);
    }

    public BinarySearchArrayIndexedHashMap(AbstractArrayMap<K, V> map, int start, int end) {
        super(map, start, end);
    }

    @Override
    public void builderInit(int size) {
        this.keysAndValues = new Object[size * 2];
    }

    @Override
    public void builderPut(int index, K key, V value) {
        this.keysAndValues[index * 2] = key;
        this.keysAndValues[index * 2 + 1] = value;
    }

    @Override
    public Map<K, V> builderFinish() {
        this.hashes = new int[this.keysAndValues.length / 2];
        for (int i = 0; i < this.keysAndValues.length / 2; ++i) {
            this.hashes[i] = this.hashCode(this.keysAndValues[i * 2]);
        }
        ArrayQuickSort.sort(this, Comparators.comparableComparator());
        return this;
    }

    @Override
    public Integer at(int index) {
        return this.hashes[index];
    }

    @Override
    public void swap(int x, int y) {
        int hashX = this.hashes[x];
        this.hashes[x] = this.hashes[y];
        this.hashes[y] = hashX;
        Utils.Array.swap(this.keysAndValues, x, y);
    }

    @Override
    public int size() {
        return this.hashes.length;
    }

    @Override
    protected K key(int index) {
        return (K)this.keysAndValues[index * 2];
    }

    @Override
    protected V value(int index) {
        return (V)this.keysAndValues[index * 2 + 1];
    }

    @Override
    public Object getUndefined(Object key) {
        int i;
        int hash = this.hashCode(key);
        int index = Arrays.binarySearch(this.hashes, hash);
        if (index < 0) {
            return AbstractArrayMap.undefined;
        }
        for (i = index; i >= 0 && this.hashes[i] == hash; --i) {
            if (!Utils.equal(key, this.key(i))) continue;
            return this.value(i);
        }
        for (i = index + 1; i < this.size() && this.hashes[i] == hash; ++i) {
            if (!Utils.equal(key, this.key(i))) continue;
            return this.value(i);
        }
        return AbstractArrayMap.undefined;
    }
}

