/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.impl;

import com.netflix.zeno.util.collections.Comparators;
import com.netflix.zeno.util.collections.algorithms.ArrayQuickSort;
import com.netflix.zeno.util.collections.algorithms.Sortable;
import com.netflix.zeno.util.collections.impl.AbstractArraySet;
import com.netflix.zeno.util.collections.impl.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;

public class BinarySearchArrayIndexedSet<E>
extends AbstractArraySet<E>
implements Sortable<Integer> {
    protected int[] hashes;
    protected Object[] elements;

    public BinarySearchArrayIndexedSet() {
    }

    public BinarySearchArrayIndexedSet(Collection<E> from) {
        super(from);
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    public Comparator<Object> comparator() {
        return Comparators.hashCodeComparator();
    }

    @Override
    public boolean contains(Object o) {
        int i;
        int hash = this.hashCode(o);
        int index = Arrays.binarySearch(this.hashes, hash);
        if (index < 0) {
            return false;
        }
        for (i = index; i >= 0 && this.hashes[i] == hash; --i) {
            if (!Utils.equal(o, this.element(i))) continue;
            return true;
        }
        for (i = index + 1; i < this.size() && this.hashes[i] == hash; ++i) {
            if (!Utils.equal(o, this.element(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected E element(int index) {
        return (E)this.elements[index];
    }

    @Override
    public void builderInit(int size) {
        this.elements = new Object[size];
    }

    @Override
    public void builderSet(int index, E element) {
        this.elements[index] = element;
    }

    @Override
    public Set<E> builderFinish() {
        this.hashes = new int[this.elements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            this.hashes[i] = this.hashCode(this.elements[i]);
        }
        ArrayQuickSort.sort(this, Comparators.comparableComparator());
        return this;
    }

    @Override
    public Integer at(int index) {
        return this.hashes[index];
    }

    @Override
    public void swap(int x, int y) {
        int hashX = this.hashes[x];
        this.hashes[x] = this.hashes[y];
        this.hashes[y] = hashX;
        Object eX = this.elements[x];
        this.elements[x] = this.elements[y];
        this.elements[y] = eX;
    }
}

