/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.impl;

import com.netflix.zeno.util.collections.Comparators;
import com.netflix.zeno.util.collections.algorithms.ArrayQuickSort;
import com.netflix.zeno.util.collections.algorithms.BinarySearch;
import com.netflix.zeno.util.collections.impl.AbstractArrayMap;
import com.netflix.zeno.util.collections.impl.AbstractArraySortedMap;
import com.netflix.zeno.util.collections.impl.Utils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;

public class BinarySearchArrayMap<K, V>
extends AbstractArraySortedMap<K, V> {
    protected Object[] keysAndValues;

    public BinarySearchArrayMap() {
        this.setMap(Collections.emptyMap());
    }

    public BinarySearchArrayMap(Map<K, V> map) {
        this.setMap(map);
    }

    public BinarySearchArrayMap(Map.Entry<K, V>[] entries) {
        this.setMap(entries);
    }

    private BinarySearchArrayMap(AbstractArrayMap<K, V> map, int start, int end) {
        super(map, start, end);
    }

    @Override
    public AbstractArraySortedMap<K, V> newMap(int start, int end) {
        return new BinarySearchArrayMap<K, V>(this, start, end);
    }

    @Override
    public void builderInit(int size) {
        this.keysAndValues = new Object[size * 2];
    }

    @Override
    public void builderPut(int i, K key, V value) {
        this.keysAndValues[i * 2] = key;
        this.keysAndValues[i * 2 + 1] = value;
    }

    @Override
    public SortedMap<K, V> builderFinish() {
        ArrayQuickSort.sort(this, this.comparator());
        return this;
    }

    @Override
    public K at(int index) {
        return this.key(index);
    }

    @Override
    public void swap(int x, int y) {
        Utils.Array.swap(this.keysAndValues, x, y);
    }

    @Override
    public int size() {
        return this.keysAndValues.length / 2;
    }

    @Override
    protected K key(int index) {
        int realIndex = index * 2;
        if (realIndex < 0 || realIndex >= this.keysAndValues.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (K)this.keysAndValues[realIndex];
    }

    @Override
    protected V value(int index) {
        int realIndex = index * 2 + 1;
        if (realIndex < 0 || realIndex >= this.keysAndValues.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (V)this.keysAndValues[realIndex];
    }

    @Override
    public Object getUndefined(Object key) {
        int i;
        int index = BinarySearch.binarySearch(this, key, this.comparator());
        if (index < 0) {
            return AbstractArrayMap.undefined;
        }
        for (i = index; i >= 0 && this.comparator().compare(this.key(i), key) == 0; --i) {
            if (!Utils.equal(key, this.key(i))) continue;
            return this.value(i);
        }
        for (i = index + 1; i < this.size() && this.comparator().compare(this.key(i), key) == 0; ++i) {
            if (!Utils.equal(key, this.key(i))) continue;
            return this.value(i);
        }
        return AbstractArrayMap.undefined;
    }

    @Override
    public Comparator<K> comparator() {
        return Comparators.comparableComparator();
    }
}

