/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.impl;

import com.netflix.zeno.util.collections.Comparators;
import com.netflix.zeno.util.collections.impl.AbstractArraySet;
import com.netflix.zeno.util.collections.impl.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;

public class BinarySearchArraySet<E>
extends AbstractArraySet<E> {
    protected Object[] elements;

    public BinarySearchArraySet() {
    }

    public BinarySearchArraySet(Collection<E> from) {
        super(from);
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    public Comparator<Object> comparator() {
        return Comparators.hashCodeComparator();
    }

    @Override
    public boolean contains(Object o) {
        int i;
        int hash = this.hashCode(o);
        int index = Arrays.binarySearch(this.elements, o, this.comparator());
        if (index < 0) {
            return false;
        }
        for (i = index; i >= 0 && this.hashCode(this.elements[i]) == hash; --i) {
            if (!Utils.equal(o, this.elements[i])) continue;
            return true;
        }
        for (i = index + 1; i < this.size() && this.hashCode(this.elements[i]) == hash; ++i) {
            if (!Utils.equal(o, this.elements[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    protected E element(int index) {
        return (E)this.elements[index];
    }

    @Override
    public void builderInit(int size) {
        this.elements = new Object[size];
    }

    @Override
    public void builderSet(int index, E element) {
        this.elements[index] = element;
    }

    @Override
    public Set<E> builderFinish() {
        Arrays.sort(this.elements, this.comparator());
        return this;
    }
}

