/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.impl;

import com.netflix.zeno.util.collections.builder.ListBuilder;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;

public class ImmutableArrayList<E>
extends AbstractList<E>
implements ListBuilder<E> {
    protected Object[] elements;

    public ImmutableArrayList() {
    }

    public ImmutableArrayList(Collection<E> collection) {
        this.setElements(collection);
    }

    protected void setElements(Collection<E> collection) {
        this.builderInit(collection.size());
        int i = 0;
        for (E entry : collection) {
            this.builderSet(i++, entry);
        }
        this.builderFinish();
    }

    @Override
    public E get(int index) {
        return (E)this.elements[index];
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public void builderInit(int size) {
        this.elements = new Object[size];
    }

    @Override
    public void builderSet(int index, E element) {
        this.elements[index] = element;
    }

    @Override
    public List<E> builderFinish() {
        return this;
    }
}

