/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.impl;

import java.util.Arrays;

public class OpenAddressing {
    public static Object newHashTable(int numEntries, float loadFactor) {
        int hashSize = (int)Math.ceil((float)numEntries / loadFactor);
        hashSize = 1 << 32 - Integer.numberOfLeadingZeros(hashSize);
        if (numEntries < 256) {
            byte[] hashTable = new byte[hashSize];
            Arrays.fill(hashTable, (byte)-1);
            return hashTable;
        }
        if (numEntries < 65536) {
            short[] hashTable = new short[hashSize];
            Arrays.fill(hashTable, (short)-1);
            return hashTable;
        }
        int[] hashTable = new int[hashSize];
        Arrays.fill(hashTable, -1);
        return hashTable;
    }

    public static int hashTableLength(Object hashTable) {
        if (hashTable instanceof byte[]) {
            return ((byte[])hashTable).length;
        }
        if (hashTable instanceof short[]) {
            return ((short[])hashTable).length;
        }
        return ((int[])hashTable).length;
    }

    public static int getHashEntry(Object hashTable, int bucket) {
        if (hashTable instanceof byte[]) {
            int entry = ((byte[])hashTable)[bucket] & 0xFF;
            return entry == 255 ? -1 : entry;
        }
        if (hashTable instanceof short[]) {
            int entry = ((short[])hashTable)[bucket] & 0xFFFF;
            return entry == 65535 ? -1 : entry;
        }
        return ((int[])hashTable)[bucket];
    }

    public static void setHashEntry(Object hashTable, int bucket, int value) {
        if (hashTable instanceof byte[]) {
            ((byte[])hashTable)[bucket] = (byte)value;
        } else if (hashTable instanceof short[]) {
            ((short[])hashTable)[bucket] = (short)value;
        } else {
            ((int[])hashTable)[bucket] = value;
        }
    }

    public static int rehash(int hash) {
        hash = ~hash + (hash << 15);
        hash ^= hash >>> 12;
        hash += hash << 2;
        hash ^= hash >>> 4;
        hash *= 2057;
        hash ^= hash >>> 16;
        return hash;
    }
}

