/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.impl;

import com.netflix.zeno.util.collections.impl.AbstractArraySet;
import com.netflix.zeno.util.collections.impl.OpenAddressing;
import com.netflix.zeno.util.collections.impl.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class OpenAddressingArraySet<E>
extends AbstractArraySet<E> {
    private Object hashTable;
    private Object[] elements;
    private int size;

    public OpenAddressingArraySet() {
    }

    public OpenAddressingArraySet(Collection<E> from) {
        super(from);
    }

    @Override
    public int size() {
        return this.size;
    }

    public float loadFactor() {
        return 0.7f;
    }

    @Override
    public boolean contains(Object o) {
        int hashModMask = OpenAddressing.hashTableLength(this.hashTable) - 1;
        int hash = this.hashCode(o);
        int bucket = hash & hashModMask;
        int hashEntry = OpenAddressing.getHashEntry(this.hashTable, bucket);
        while (hashEntry >= 0) {
            if (Utils.equal(this.elements[hashEntry], o)) {
                return true;
            }
            bucket = bucket + 1 & hashModMask;
            hashEntry = OpenAddressing.getHashEntry(this.hashTable, bucket);
        }
        return false;
    }

    @Override
    protected E element(int index) {
        return (E)this.elements[index];
    }

    @Override
    public void builderInit(int numEntries) {
        this.hashTable = OpenAddressing.newHashTable(numEntries, this.loadFactor());
        this.elements = new Object[numEntries];
    }

    @Override
    public void builderSet(int index, E element) {
        this.elements[this.size++] = element;
    }

    @Override
    public Set<E> builderFinish() {
        if (this.elements.length > this.size) {
            this.elements = Arrays.copyOf(this.elements, this.size);
        }
        int hashModMask = OpenAddressing.hashTableLength(this.hashTable) - 1;
        for (int i = 0; i < this.elements.length; ++i) {
            int hash = this.hashCode(this.elements[i]);
            int bucket = hash & hashModMask;
            while (OpenAddressing.getHashEntry(this.hashTable, bucket) != -1) {
                bucket = bucket + 1 & hashModMask;
            }
            OpenAddressing.setHashEntry(this.hashTable, bucket, i);
        }
        return this;
    }

    @Override
    protected int rehash(int hash) {
        return OpenAddressing.rehash(hash);
    }
}

