/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.impl;

import com.netflix.zeno.util.collections.builder.MapBuilder;
import com.netflix.zeno.util.collections.impl.AbstractArrayMap;
import com.netflix.zeno.util.collections.impl.OpenAddressing;
import com.netflix.zeno.util.collections.impl.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class OpenAddressingHashMap<K, V>
extends AbstractArrayMap<K, V>
implements MapBuilder<K, V> {
    protected Object hashTable;
    protected Object[] keysAndValues;
    protected int size;

    public OpenAddressingHashMap() {
        this.setMap(Collections.emptyMap());
    }

    public OpenAddressingHashMap(Map<K, V> map) {
        this.setMap(map);
    }

    public OpenAddressingHashMap(Map.Entry<K, V>[] entries) {
        this.setMap(entries);
    }

    public OpenAddressingHashMap(AbstractArrayMap<K, V> map, int start, int end) {
        super(map, start, end);
    }

    public float loadFactor() {
        return 0.7f;
    }

    @Override
    public void builderInit(int numEntries) {
        this.hashTable = OpenAddressing.newHashTable(numEntries, this.loadFactor());
        this.keysAndValues = new Object[numEntries * 2];
    }

    @Override
    public void builderPut(int index, K key, V value) {
        this.keysAndValues[this.size * 2] = key;
        this.keysAndValues[this.size * 2 + 1] = value;
        ++this.size;
    }

    @Override
    public Map<K, V> builderFinish() {
        int hashModMask = OpenAddressing.hashTableLength(this.hashTable) - 1;
        if (this.keysAndValues.length > this.size * 2) {
            this.keysAndValues = Arrays.copyOf(this.keysAndValues, this.size * 2);
        }
        for (int i = 0; i < this.keysAndValues.length; i += 2) {
            int hash = this.hashCode(this.keysAndValues[i]);
            int bucket = hash & hashModMask;
            while (OpenAddressing.getHashEntry(this.hashTable, bucket) != -1) {
                bucket = bucket + 1 & hashModMask;
            }
            OpenAddressing.setHashEntry(this.hashTable, bucket, i / 2);
        }
        return this;
    }

    @Override
    protected int rehash(int hash) {
        return OpenAddressing.rehash(hash);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    protected K key(int index) {
        return (K)this.keysAndValues[index * 2];
    }

    @Override
    protected V value(int index) {
        return (V)this.keysAndValues[index * 2 + 1];
    }

    @Override
    public Object getUndefined(Object key) {
        int hashModMask = OpenAddressing.hashTableLength(this.hashTable) - 1;
        int hash = this.hashCode(key);
        int bucket = hash & hashModMask;
        int hashEntry = OpenAddressing.getHashEntry(this.hashTable, bucket) * 2;
        while (hashEntry >= 0) {
            if (Utils.equal(this.keysAndValues[hashEntry], key)) {
                return this.keysAndValues[hashEntry + 1];
            }
            bucket = bucket + 1 & hashModMask;
            hashEntry = OpenAddressing.getHashEntry(this.hashTable, bucket) * 2;
        }
        return AbstractArrayMap.undefined;
    }
}

