/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.impl;

import com.netflix.zeno.util.collections.Comparators;
import com.netflix.zeno.util.collections.algorithms.ArrayQuickSort;
import com.netflix.zeno.util.collections.algorithms.BinarySearch;
import com.netflix.zeno.util.collections.algorithms.Sortable;
import com.netflix.zeno.util.collections.builder.MapBuilder;
import com.netflix.zeno.util.collections.impl.AbstractArrayMap;
import com.netflix.zeno.util.collections.impl.OpenAddressingHashMap;
import com.netflix.zeno.util.collections.impl.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;

public class OpenAddressingSortedHashMap<K, V>
extends OpenAddressingHashMap<K, V>
implements MapBuilder<K, V>,
SortedMap<K, V>,
Sortable<K> {
    public OpenAddressingSortedHashMap() {
        this.setMap(Collections.emptyMap());
    }

    public OpenAddressingSortedHashMap(Map<K, V> map) {
        this.setMap(map);
    }

    public OpenAddressingSortedHashMap(AbstractArrayMap<K, V> map, int start, int end) {
        super(map, start, end);
    }

    public OpenAddressingSortedHashMap(Map.Entry<K, V>[] entries) {
        this.setMap(entries);
    }

    @Override
    public SortedMap<K, V> builderFinish() {
        if (this.keysAndValues.length > this.size * 2) {
            this.keysAndValues = Arrays.copyOf(this.keysAndValues, this.size * 2);
        }
        if (this.comparator() != null) {
            ArrayQuickSort.sort(this, this.comparator());
        }
        super.builderFinish();
        return this;
    }

    @Override
    public K at(int index) {
        return this.key(index);
    }

    @Override
    public void swap(int x, int y) {
        Utils.Array.swap(this.keysAndValues, x, y);
    }

    @Override
    public int size() {
        return this.keysAndValues.length / 2;
    }

    @Override
    public Comparator<K> comparator() {
        return Comparators.comparableComparator();
    }

    public SortedMap<K, V> newMap(int start, int end) {
        return new OpenAddressingSortedHashMap<K, V>(this, start, end);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        int start = 0;
        if (fromKey != null) {
            start = BinarySearch.binarySearch(this, fromKey, this.comparator());
            int i = start = start >= 0 ? start : -start - 1;
            while (i >= 0 && i < this.size() && this.comparator().compare(this.key(i), fromKey) >= 0) {
                start = i--;
            }
        }
        int end = this.size();
        if (toKey != null) {
            end = BinarySearch.binarySearch(this, toKey, this.comparator());
            int i = end = end >= 0 ? end : -end - 1;
            while (i >= 0 && i < this.size() && this.comparator().compare(this.key(i), toKey) < 0) {
                end = i++;
            }
        }
        start = Math.max(start, 0);
        end = Math.min(end, this.size());
        return this.newMap(start, end);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.subMap(null, toKey);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return this.subMap(fromKey, null);
    }

    @Override
    public K firstKey() {
        return this.key(0);
    }

    @Override
    public K lastKey() {
        return this.key(this.size() - 1);
    }
}

