/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.util.collections.impl;

import com.netflix.zeno.util.collections.impl.NetflixCollections;
import com.netflix.zeno.util.collections.impl.Utils;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class SingletonSortedMap<K, V>
extends AbstractMap<K, V>
implements SortedMap<K, V>,
Serializable {
    private static final long serialVersionUID = 4009578255191820277L;
    private final K key;
    private final V value;

    public SingletonSortedMap(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public boolean containsKey(Object object) {
        return Utils.equal(this.key, object);
    }

    @Override
    public boolean containsValue(Object object) {
        return Utils.equal(this.value, object);
    }

    @Override
    public V get(Object object) {
        return Utils.equal(this.key, object) ? (V)this.value : null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<K> keySet() {
        return Collections.singleton(this.key);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Collection<V> values() {
        return Collections.singleton(this.value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.singleton(new AbstractMap.SimpleImmutableEntry<K, V>(this.key, this.value));
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator();
    }

    @Override
    public K firstKey() {
        return this.key;
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.comparator().compare(this.key, toKey) < 0 ? this : NetflixCollections.emptySortedMap();
    }

    @Override
    public K lastKey() {
        return this.key;
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        Comparator<K> comparator = this.comparator();
        return comparator.compare(this.key, toKey) < 0 && comparator.compare(this.key, fromKey) >= 0 ? this : NetflixCollections.emptySortedMap();
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return this.comparator().compare(this.key, fromKey) >= 0 ? this : NetflixCollections.emptySortedMap();
    }
}

