/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.discovery;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import com.netflix.zuul.discovery.ResolverResult;
import com.netflix.zuul.discovery.SimpleMetaInfo;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class DiscoveryResult
implements ResolverResult {
    private final DiscoveryEnabledServer server;
    private final ServerStats serverStats;
    public static final DiscoveryResult EMPTY = DiscoveryResult.from(InstanceInfo.Builder.newBuilder().setAppName("undefined").setHostName("undefined").setPort(-1).build(), false);

    public DiscoveryResult(DiscoveryEnabledServer server, LoadBalancerStats lbStats) {
        this.server = server;
        Objects.requireNonNull(lbStats, "Loadbalancer stats must be a valid instance");
        this.serverStats = lbStats.getSingleServerStat((Server)server);
    }

    public DiscoveryResult(DiscoveryEnabledServer server) {
        this.server = server;
        this.serverStats = new ServerStats();
    }

    @VisibleForTesting
    public static DiscoveryResult from(InstanceInfo instanceInfo, boolean useSecurePort) {
        DiscoveryEnabledServer server = new DiscoveryEnabledServer(instanceInfo, useSecurePort);
        return new DiscoveryResult(server);
    }

    public Optional<String> getIPAddr() {
        if (this == EMPTY) {
            return Optional.empty();
        }
        if (this.server.getInstanceInfo() != null) {
            String ip = this.server.getInstanceInfo().getIPAddr();
            if (ip != null && !ip.isEmpty()) {
                return Optional.of(ip);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public String getHost() {
        return this.server == null ? "undefined" : this.server.getHost();
    }

    @Override
    public boolean isDiscoveryEnabled() {
        return this.server instanceof DiscoveryEnabledServer;
    }

    @Override
    public int getPort() {
        return this.server == null ? -1 : this.server.getPort();
    }

    public int getSecurePort() {
        return this.server.getInstanceInfo().getSecurePort();
    }

    public boolean isSecurePortEnabled() {
        return this.server.getInstanceInfo().isPortEnabled(InstanceInfo.PortType.SECURE);
    }

    public String getTarget() {
        InstanceInfo instanceInfo = this.server.getInstanceInfo();
        if (this.server.getPort() == instanceInfo.getSecurePort()) {
            return instanceInfo.getSecureVipAddress();
        }
        return instanceInfo.getVIPAddress();
    }

    public SimpleMetaInfo getMetaInfo() {
        return new SimpleMetaInfo(this.server.getMetaInfo());
    }

    @Nullable
    public String getAvailabilityZone() {
        InstanceInfo instanceInfo = this.server.getInstanceInfo();
        if (instanceInfo.getDataCenterInfo() instanceof AmazonInfo) {
            return (String)((AmazonInfo)instanceInfo.getDataCenterInfo()).getMetadata().get("availability-zone");
        }
        return null;
    }

    public String getZone() {
        return this.server.getZone();
    }

    public String getServerId() {
        return this.server.getInstanceInfo().getId();
    }

    public DiscoveryEnabledServer getServer() {
        return this.server;
    }

    @VisibleForTesting
    ServerStats getServerStats() {
        return this.serverStats;
    }

    public String getASGName() {
        return this.server.getInstanceInfo().getASGName();
    }

    public String getAppName() {
        return this.server.getInstanceInfo().getAppName().toLowerCase(Locale.ROOT);
    }

    public void noteResponseTime(double msecs) {
        this.serverStats.noteResponseTime(msecs);
    }

    public boolean isCircuitBreakerTripped() {
        return this.serverStats.isCircuitBreakerTripped();
    }

    public void incrementActiveRequestsCount() {
        this.serverStats.incrementActiveRequestsCount();
    }

    public void incrementOpenConnectionsCount() {
        this.serverStats.incrementOpenConnectionsCount();
    }

    public void incrementSuccessiveConnectionFailureCount() {
        this.serverStats.incrementSuccessiveConnectionFailureCount();
    }

    public void incrementNumRequests() {
        this.serverStats.incrementNumRequests();
    }

    public int getOpenConnectionsCount() {
        return this.serverStats.getOpenConnectionsCount();
    }

    public long getTotalRequestsCount() {
        return this.serverStats.getTotalRequestsCount();
    }

    public int getActiveRequestsCount() {
        return this.serverStats.getActiveRequestsCount();
    }

    public void decrementOpenConnectionsCount() {
        this.serverStats.decrementOpenConnectionsCount();
    }

    public void decrementActiveRequestsCount() {
        this.serverStats.decrementActiveRequestsCount();
    }

    public void clearSuccessiveConnectionFailureCount() {
        this.serverStats.clearSuccessiveConnectionFailureCount();
    }

    public void addToFailureCount() {
        this.serverStats.addToFailureCount();
    }

    public void stopPublishingStats() {
        this.serverStats.close();
    }

    public int hashCode() {
        return Objects.hashCode(this.server);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DiscoveryResult)) {
            return false;
        }
        DiscoveryResult other = (DiscoveryResult)obj;
        return this.server.equals((Object)other.server);
    }
}

