
package com.netgrif.application.engine.importer.model;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for appearance.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="appearance"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="standard"/&gt;
 *     &lt;enumeration value="outline"/&gt;
 *     &lt;enumeration value="fill"/&gt;
 *     &lt;enumeration value="legacy"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "appearance")
@XmlEnum
public enum Appearance {

    @XmlEnumValue("standard")
    STANDARD("standard"),
    @XmlEnumValue("outline")
    OUTLINE("outline"),
    @XmlEnumValue("fill")
    FILL("fill"),
    @XmlEnumValue("legacy")
    LEGACY("legacy");
    private final String value;

    Appearance(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static Appearance fromValue(String v) {
        for (Appearance c: Appearance.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
