/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine;

import com.netgrif.application.engine.configuration.ApplicationContextProvider;
import com.netgrif.application.engine.configuration.JsonRootRelProvider;
import com.netgrif.application.engine.petrinet.domain.version.StringToVersionConverter;
import java.util.ArrayList;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.data.mongodb.config.EnableMongoAuditing;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;

@EnableCaching
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
@EnableGlobalMethodSecurity(prePostEnabled=true)
@EnableAspectJAutoProxy
@SpringBootApplication(exclude={DataSourceAutoConfiguration.class})
@EnableMongoAuditing
@Aspect
public class ApplicationEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationEngine.class);

    @Around(value="execution(* com.netgrif.application.engine.startup.AbstractOrderedCommandLineRunner+.run(..))")
    void logRun(ProceedingJoinPoint joinPoint) throws Throwable {
        log.info(joinPoint.getTarget().getClass().getSimpleName() + " started");
        joinPoint.proceed();
        log.info(joinPoint.getTarget().getClass().getSimpleName() + " finished");
    }

    @Bean
    public MongoCustomConversions customConversions() {
        ArrayList<StringToVersionConverter> converters = new ArrayList<StringToVersionConverter>();
        converters.add(new StringToVersionConverter());
        return new MongoCustomConversions(converters);
    }

    @Bean
    LinkRelationProvider relProvider() {
        return new JsonRootRelProvider();
    }

    @Bean
    ApplicationContextProvider applicationContextProvider() {
        return new ApplicationContextProvider();
    }

    public static void main(String[] args) {
        SpringApplication.run(ApplicationEngine.class, (String[])args);
    }
}

