/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.auth.domain;

import com.netgrif.application.engine.auth.domain.Author;
import com.netgrif.application.engine.auth.domain.Authority;
import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.UserState;
import com.netgrif.application.engine.petrinet.domain.roles.ProcessRole;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.springframework.data.annotation.Transient;

public abstract class AbstractUser
implements IUser,
Serializable {
    private static final long serialVersionUID = 341922197277508726L;
    @NotNull
    protected UserState state;
    protected Set<Authority> authorities = new HashSet<Authority>();
    protected Set<ProcessRole> processRoles;
    protected Set<String> nextGroups = new HashSet<String>();
    @Transient
    protected IUser impersonated;

    public AbstractUser() {
        this.processRoles = new HashSet<ProcessRole>();
    }

    @Override
    public void addAuthority(Authority authority) {
        if (this.authorities.stream().anyMatch(it -> it.get_id().equals((Object)authority.get_id()))) {
            return;
        }
        this.authorities.add(authority);
    }

    @Override
    public void addProcessRole(ProcessRole role) {
        if (this.processRoles.stream().anyMatch(it -> it.getStringId().equals(role.getStringId()))) {
            return;
        }
        this.processRoles.add(role);
    }

    @Override
    public void removeProcessRole(ProcessRole role) {
        this.processRoles.remove(role);
    }

    @Override
    public void addGroup(String groupId) {
        this.nextGroups.add(groupId);
    }

    @Override
    public void removeGroup(String groupId) {
        this.nextGroups.remove(groupId);
    }

    @Override
    public boolean isActive() {
        return UserState.ACTIVE.equals((Object)this.state) || UserState.BLOCKED.equals((Object)this.state);
    }

    @Override
    public Author transformToAuthor() {
        Author author = new Author();
        author.setId(this.getStringId());
        author.setEmail(this.getEmail());
        author.setFullName(this.getFullName());
        return author;
    }

    @Override
    public boolean isImpersonating() {
        return this.impersonated != null;
    }

    @Override
    public IUser getSelfOrImpersonated() {
        return this.isImpersonating() ? this.impersonated : this;
    }

    @Override
    @Generated
    public UserState getState() {
        return this.state;
    }

    @Override
    @Generated
    public void setState(UserState state) {
        this.state = state;
    }

    @Override
    @Generated
    public Set<Authority> getAuthorities() {
        return this.authorities;
    }

    @Override
    @Generated
    public void setAuthorities(Set<Authority> authorities) {
        this.authorities = authorities;
    }

    @Override
    @Generated
    public Set<ProcessRole> getProcessRoles() {
        return this.processRoles;
    }

    @Override
    @Generated
    public void setProcessRoles(Set<ProcessRole> processRoles) {
        this.processRoles = processRoles;
    }

    @Override
    @Generated
    public Set<String> getNextGroups() {
        return this.nextGroups;
    }

    @Override
    @Generated
    public void setNextGroups(Set<String> nextGroups) {
        this.nextGroups = nextGroups;
    }

    @Override
    @Generated
    public void setImpersonated(IUser impersonated) {
        this.impersonated = impersonated;
    }

    @Override
    @Generated
    public IUser getImpersonated() {
        return this.impersonated;
    }
}

