/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.auth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netgrif.application.engine.auth.domain.IUser;
import java.util.HashSet;
import java.util.Set;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.security.core.GrantedAuthority;

@Document
public class Authority
implements GrantedAuthority {
    public static final long serialVersionUID = 2839744057647464485L;
    public static final String PERMISSION = "PERM_";
    public static final String ROLE = "ROLE_";
    public static final String admin = "ROLE_ADMIN";
    public static final String systemAdmin = "ROLE_SYSTEMADMIN";
    public static final String user = "ROLE_USER";
    public static final String anonymous = "ROLE_ANONYMOUS";
    @Id
    private ObjectId _id;
    @NotNull
    @JsonIgnore
    private String name;
    @JsonIgnore
    private Set<String> users;

    public Authority() {
    }

    public Authority(String name) {
        this.name = name;
    }

    public static Authority createRole(String name) {
        return new Authority(ROLE + name);
    }

    public static Authority createPermission(String name) {
        return new Authority(PERMISSION + name);
    }

    public void addUser(IUser user) {
        if (this.users == null) {
            this.users = new HashSet<String>();
        }
        this.users.add(user.getStringId());
    }

    public String getStringId() {
        return this._id.toString();
    }

    public String getAuthority() {
        return this.name;
    }

    public void setAuthority(String authority) {
        this.name = authority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Authority authority = (Authority)o;
        return this.name.equals(authority.name);
    }

    public String toString() {
        return "Authority{id=" + this._id + ", name='" + this.name + "'}";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Generated
    public ObjectId get_id() {
        return this._id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public Set<String> getUsers() {
        return this.users;
    }

    @JsonIgnore
    @Generated
    public void setUsers(Set<String> users) {
        this.users = users;
    }
}

