/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.auth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.netgrif.application.engine.auth.domain.AnonymousUser;
import com.netgrif.application.engine.auth.domain.Author;
import com.netgrif.application.engine.auth.domain.Authority;
import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.User;
import com.netgrif.application.engine.auth.domain.UserState;
import com.netgrif.application.engine.petrinet.domain.roles.ProcessRole;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.springframework.security.core.GrantedAuthority;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LoggedUser
extends org.springframework.security.core.userdetails.User {
    public static final long serialVersionUID = 3031325636490953409L;
    protected String id;
    protected String fullName;
    protected Set<String> groups;
    protected Set<String> processRoles;
    protected boolean anonymous;
    private LoggedUser impersonated;

    public LoggedUser(String id, String username, String password, Collection<? extends GrantedAuthority> authorities) {
        super(username, password, authorities);
        this.id = id;
        this.processRoles = new HashSet<String>();
        this.groups = new HashSet<String>();
    }

    public void parseProcessRoles(Set<ProcessRole> processRoles) {
        processRoles.forEach(role -> this.processRoles.add(role.getStringId()));
    }

    public boolean isAdmin() {
        return this.getAuthorities().contains(new Authority("ROLE_ADMIN"));
    }

    public String getEmail() {
        return this.getUsername();
    }

    public IUser transformToUser() {
        User user = new User(new ObjectId(this.id));
        user.setEmail(this.getUsername());
        String[] names = this.fullName.split(" ");
        user.setName(names[0]);
        user.setSurname(names[1]);
        user.setPassword(this.getPassword());
        user.setState(UserState.ACTIVE);
        user.setAuthorities(this.getAuthorities().stream().map(a -> (Authority)a).collect(Collectors.toSet()));
        user.setNextGroups(this.groups.stream().map(String::new).collect(Collectors.toSet()));
        user.setProcessRoles(this.processRoles.stream().map(roleId -> {
            ProcessRole role = new ProcessRole();
            role.set_id((String)roleId);
            return role;
        }).collect(Collectors.toSet()));
        if (this.isImpersonating()) {
            user.setImpersonated(this.getImpersonated().transformToUser());
        }
        return user;
    }

    public AnonymousUser transformToAnonymousUser() {
        AnonymousUser anonym = new AnonymousUser(new ObjectId(this.id));
        anonym.setEmail(this.getUsername());
        anonym.setName("Anonymous");
        anonym.setSurname("User");
        anonym.setPassword("n/a");
        anonym.setState(UserState.ACTIVE);
        anonym.setAuthorities(this.getAuthorities().stream().map(a -> (Authority)a).collect(Collectors.toSet()));
        anonym.setNextGroups(this.groups.stream().map(String::new).collect(Collectors.toSet()));
        anonym.setProcessRoles(this.processRoles.stream().map(roleId -> {
            ProcessRole role = new ProcessRole();
            role.set_id((String)roleId);
            return role;
        }).collect(Collectors.toSet()));
        return anonym;
    }

    public void impersonate(LoggedUser toImpersonate) {
        this.impersonated = toImpersonate;
    }

    public void clearImpersonated() {
        this.impersonated = null;
    }

    public boolean isImpersonating() {
        return this.impersonated != null;
    }

    @JsonIgnore
    public LoggedUser getSelfOrImpersonated() {
        return this.isImpersonating() ? this.impersonated : this;
    }

    public String toString() {
        return "LoggedUser{id=" + this.id + ", fullName='" + this.fullName + "', groups=" + this.groups + ", processRoles=" + this.processRoles + ", impersonated=" + this.impersonated + "}";
    }

    public Author transformToAuthor() {
        Author author = new Author();
        author.setId(this.id);
        author.setEmail(this.getUsername());
        author.setFullName(this.fullName);
        return author;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public String getFullName() {
        return this.fullName;
    }

    @Generated
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Generated
    public Set<String> getGroups() {
        return this.groups;
    }

    @Generated
    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @Generated
    public Set<String> getProcessRoles() {
        return this.processRoles;
    }

    @Generated
    public void setProcessRoles(Set<String> processRoles) {
        this.processRoles = processRoles;
    }

    @Generated
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Generated
    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Generated
    public LoggedUser getImpersonated() {
        return this.impersonated;
    }
}

