/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.auth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netgrif.application.engine.auth.domain.AbstractUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.domain.RegisteredUser;
import com.netgrif.application.engine.petrinet.domain.roles.ProcessRole;
import java.time.LocalDateTime;
import java.util.HashSet;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class User
extends AbstractUser
implements RegisteredUser {
    public static final String UNKNOWN = "unknown";
    @Id
    protected ObjectId _id;
    @NotNull
    @Indexed(unique=true)
    protected String email;
    protected String telNumber;
    protected String avatar;
    @JsonIgnore
    protected String password;
    @NotNull
    @Indexed
    protected String name;
    @NotNull
    @Indexed
    protected String surname;
    protected String token;
    protected LocalDateTime expirationDate;

    public User() {
    }

    public User(ObjectId id) {
        this();
        this._id = id;
        this.nextGroups = new HashSet();
    }

    public User(User user) {
        this._id = user.get_id();
        this.email = user.getEmail();
        this.surname = user.getSurname();
        this.name = user.getName();
        this.state = user.getState();
    }

    public User(String email, String password, String name, String surname) {
        this();
        this.email = email;
        this.password = password;
        this.name = name;
        this.surname = surname;
        this.nextGroups = new HashSet();
    }

    public User(ObjectNode json) {
        this(json.get("email").asText(), null, json.get("name").asText(), json.get("surname").asText());
        ((ArrayNode)json.get("processRoles")).forEach(node -> this.processRoles.add(new ProcessRole(node.get("_id").asText())));
    }

    @Override
    public String getFullName() {
        return this.name + " " + this.surname;
    }

    @Override
    @JsonIgnore
    public String getStringId() {
        return this._id.toString();
    }

    @JsonIgnore
    public String getId() {
        return this._id.toString();
    }

    @Override
    public LoggedUser transformToLoggedUser() {
        LoggedUser loggedUser = new LoggedUser(this.get_id().toString(), this.getEmail(), this.getPassword(), this.getAuthorities());
        loggedUser.setFullName(this.getFullName());
        loggedUser.setAnonymous(false);
        if (!this.getProcessRoles().isEmpty()) {
            loggedUser.parseProcessRoles(this.getProcessRoles());
        }
        loggedUser.setGroups(this.getNextGroups());
        if (this.isImpersonating()) {
            loggedUser.impersonate(this.getImpersonated().transformToLoggedUser());
        }
        return loggedUser;
    }

    public String toString() {
        return "User{id=" + this._id + ", email='" + this.email + "', telNumber='" + this.telNumber + "', avatar='" + this.avatar + "', name='" + this.name + "', surname='" + this.surname + "', state=" + this.state + ", token='" + this.token + "', expirationDate=" + this.expirationDate + ", authorities=" + this.authorities + ", processRoles=" + this.processRoles + ", groups=" + this.nextGroups + "}";
    }

    @Generated
    public ObjectId get_id() {
        return this._id;
    }

    @Override
    @Generated
    public String getEmail() {
        return this.email;
    }

    @Override
    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    @Generated
    public String getTelNumber() {
        return this.telNumber;
    }

    @Generated
    public void setTelNumber(String telNumber) {
        this.telNumber = telNumber;
    }

    @Override
    @Generated
    public String getAvatar() {
        return this.avatar;
    }

    @Generated
    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    @Override
    @Generated
    public String getPassword() {
        return this.password;
    }

    @Override
    @JsonIgnore
    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Generated
    public String getSurname() {
        return this.surname;
    }

    @Override
    @Generated
    public void setSurname(String surname) {
        this.surname = surname;
    }

    @Override
    @Generated
    public String getToken() {
        return this.token;
    }

    @Override
    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public LocalDateTime getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    @Generated
    public void setExpirationDate(LocalDateTime expirationDate) {
        this.expirationDate = expirationDate;
    }
}

