/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.auth.service;

import com.netgrif.application.engine.auth.domain.Authority;
import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.domain.User;
import com.netgrif.application.engine.auth.domain.UserState;
import com.netgrif.application.engine.auth.domain.repositories.UserRepository;
import com.netgrif.application.engine.auth.service.interfaces.IAuthorityService;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.orgstructure.groups.interfaces.INextGroupService;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.roles.ProcessRole;
import com.netgrif.application.engine.petrinet.service.interfaces.IProcessRoleService;
import com.netgrif.application.engine.security.service.ISecurityContextService;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class AbstractUserService
implements IUserService {
    @Autowired
    protected IAuthorityService authorityService;
    @Autowired
    protected IProcessRoleService processRoleService;
    @Autowired
    protected INextGroupService groupService;
    @Autowired
    protected UserRepository repository;
    @Autowired
    private ISecurityContextService securityContextService;

    @Override
    public void addDefaultRole(IUser user) {
        user.addProcessRole(this.processRoleService.defaultRole());
    }

    @Override
    public void addDefaultAuthorities(IUser user) {
        if (user.getAuthorities().isEmpty()) {
            HashSet<Authority> authorities = new HashSet<Authority>();
            authorities.add(this.authorityService.getOrCreate("ROLE_USER"));
            user.setAuthorities(authorities);
        }
    }

    @Override
    public IUser assignAuthority(String userId, String authorityId) {
        IUser user = this.resolveById(userId, true);
        Authority authority = this.authorityService.getOne(authorityId);
        user.addAuthority(authority);
        authority.addUser(user);
        return this.save(user);
    }

    @Override
    public LoggedUser getAnonymousLogged() {
        if (SecurityContextHolder.getContext().getAuthentication().getPrincipal().equals("anonymousUser")) {
            this.getLoggedUser().transformToLoggedUser();
        }
        return (LoggedUser)((Object)SecurityContextHolder.getContext().getAuthentication().getPrincipal());
    }

    @Override
    public IUser addRole(IUser user, String roleStringId) {
        ProcessRole role = this.processRoleService.findById(roleStringId);
        user.addProcessRole(role);
        this.securityContextService.saveToken(user.getStringId());
        this.securityContextService.reloadSecurityContext(user.transformToLoggedUser());
        return this.save(user);
    }

    @Override
    @Deprecated(since="6.2.0")
    public IUser removeRole(IUser user, String roleStringId) {
        return this.removeRole(user, this.processRoleService.findById(roleStringId));
    }

    protected IUser removeRole(IUser user, ProcessRole role) {
        user.removeProcessRole(role);
        this.securityContextService.saveToken(user.getStringId());
        this.securityContextService.reloadSecurityContext(user.transformToLoggedUser());
        return this.save(user);
    }

    @Override
    public void removeRoleOfDeletedPetriNet(PetriNet net) {
        List<IUser> users = this.findAllByProcessRoles(net.getRoles().keySet(), false);
        users.forEach(u -> net.getRoles().forEach((k, role) -> this.removeRole((IUser)u, (ProcessRole)role)));
    }

    @Override
    public IUser createSystemUser() {
        User system = this.repository.findByEmail("engine@netgrif.com");
        if (system == null) {
            system = new User("engine@netgrif.com", "n/a", "application", "engine");
            system.setState(UserState.ACTIVE);
            this.repository.save(system);
        }
        return system;
    }

    public <T> Page<IUser> changeType(Page<T> users, Pageable pageable) {
        return new PageImpl(this.changeType(users.getContent()), pageable, users.getTotalElements());
    }

    public <T> List<IUser> changeType(List<T> users) {
        return users.stream().map(IUser.class::cast).collect(Collectors.toList());
    }
}

