/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.auth.service;

import com.netgrif.application.engine.auth.domain.Authority;
import com.netgrif.application.engine.auth.domain.repositories.AuthorityRepository;
import com.netgrif.application.engine.auth.service.interfaces.IAuthorityService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthorityService
implements IAuthorityService {
    @Autowired
    private AuthorityRepository repository;

    @Override
    public List<Authority> findAll() {
        return this.repository.findAll();
    }

    @Override
    @Transactional
    public Authority getOrCreate(String name) {
        Authority authority = this.repository.findByName(name);
        if (authority == null) {
            authority = (Authority)this.repository.save(new Authority(name));
        }
        return authority;
    }

    @Override
    public Authority getOrCreatePermission(String name) {
        return this.getOrCreate("PERM_" + name);
    }

    @Override
    public Authority getOrCreateRole(String name) {
        return this.getOrCreate("ROLE_" + name);
    }

    @Override
    public List<Authority> getAllPermissions() {
        return this.repository.findAllByNameStartsWith("PERM_");
    }

    @Override
    public List<Authority> getAllRoles() {
        return this.repository.findAllByNameStartsWith("ROLE_");
    }

    @Override
    public Authority getOne(String id) {
        Optional authority = this.repository.findById(id);
        if (!authority.isPresent()) {
            throw new IllegalArgumentException("Could not find authority with id [" + id + "]");
        }
        return (Authority)authority.get();
    }

    @Override
    public List<Authority> findAllByIds(List<String> ids) {
        return this.repository.findAllBy_idIn(ids.stream().map(ObjectId::new).collect(Collectors.toList()));
    }
}

