/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.auth.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.netgrif.application.engine.auth.service.interfaces.ILoginAttemptService;
import com.netgrif.application.engine.configuration.properties.SecurityLimitsProperties;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginAttemptService
implements ILoginAttemptService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginAttemptService.class);
    @Autowired
    private SecurityLimitsProperties securityLimitsProperties;
    private LoadingCache<String, Integer> attemptsCache;

    public LoginAttemptService(SecurityLimitsProperties securityLimitsProperties) {
        this.attemptsCache = CacheBuilder.newBuilder().expireAfterWrite((long)securityLimitsProperties.getLoginTimeout(), securityLimitsProperties.getLoginTimeoutUnit()).build((CacheLoader)new CacheLoader<String, Integer>(){

            public Integer load(String key) {
                return 0;
            }
        });
    }

    @Override
    public void loginSucceeded(String key) {
        this.attemptsCache.invalidate((Object)key);
    }

    @Override
    public void loginFailed(String key) {
        int attempts = 0;
        try {
            attempts = (Integer)this.attemptsCache.get((Object)key);
        }
        catch (ExecutionException e) {
            log.error("Error reading login attempts cache for key " + key, (Throwable)e);
            attempts = 0;
        }
        this.attemptsCache.put((Object)key, (Object)(++attempts));
    }

    @Override
    public boolean isBlocked(String key) {
        try {
            return (Integer)this.attemptsCache.get((Object)key) >= this.securityLimitsProperties.getLoginAttempts();
        }
        catch (ExecutionException e) {
            log.error("Error reading login attempts cache for key " + key, (Throwable)e);
            return false;
        }
    }
}

