/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.auth.service;

import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.domain.User;
import com.netgrif.application.engine.auth.domain.UserState;
import com.netgrif.application.engine.auth.domain.repositories.UserRepository;
import com.netgrif.application.engine.auth.service.interfaces.ILoginAttemptService;
import com.netgrif.application.engine.event.events.user.UserLoginEvent;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserDetailsServiceImpl
implements UserDetailsService {
    private static final Logger logger = LoggerFactory.getLogger(UserDetailsServiceImpl.class);
    @Autowired
    protected UserRepository userRepository;
    @Autowired
    protected ApplicationEventPublisher publisher;
    @Autowired
    protected ILoginAttemptService loginAttemptService;
    @Autowired
    protected HttpServletRequest request;

    @Transactional(readOnly=true)
    public UserDetails loadUserByUsername(String email) throws UsernameNotFoundException {
        String ip = this.getClientIP();
        if (this.loginAttemptService.isBlocked(ip)) {
            logger.info("User " + email + " with IP Address " + ip + " is blocked.");
            throw new RuntimeException("blocked");
        }
        LoggedUser loggedUser = this.getLoggedUser(email);
        this.publisher.publishEvent((ApplicationEvent)new UserLoginEvent(loggedUser));
        return loggedUser;
    }

    protected LoggedUser getLoggedUser(String email) throws UsernameNotFoundException {
        User user = this.userRepository.findByEmail(email);
        if (user == null) {
            throw new UsernameNotFoundException("No user was found for login: " + email);
        }
        if (user.getPassword() == null || user.getState() != UserState.ACTIVE) {
            throw new UsernameNotFoundException("User with login " + email + " cannot be logged in!");
        }
        return user.transformToLoggedUser();
    }

    protected String getClientIP() {
        String xfHeader = this.request.getHeader("X-Forwarded-For");
        if (xfHeader == null) {
            return this.request.getRemoteAddr();
        }
        return xfHeader.split(",")[0];
    }
}

