/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.auth.service;

import com.netgrif.application.engine.auth.domain.AnonymousUser;
import com.netgrif.application.engine.auth.domain.Authority;
import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.domain.QUser;
import com.netgrif.application.engine.auth.domain.RegisteredUser;
import com.netgrif.application.engine.auth.domain.User;
import com.netgrif.application.engine.auth.domain.UserState;
import com.netgrif.application.engine.auth.domain.repositories.AuthorityRepository;
import com.netgrif.application.engine.auth.domain.repositories.UserRepository;
import com.netgrif.application.engine.auth.service.AbstractUserService;
import com.netgrif.application.engine.auth.service.interfaces.IRegistrationService;
import com.netgrif.application.engine.auth.web.requestbodies.UpdateUserRequest;
import com.netgrif.application.engine.event.events.user.UserRegistrationEvent;
import com.netgrif.application.engine.orgstructure.groups.config.GroupConfigurationProperties;
import com.netgrif.application.engine.orgstructure.groups.interfaces.INextGroupService;
import com.netgrif.application.engine.petrinet.domain.roles.ProcessRole;
import com.netgrif.application.engine.petrinet.domain.roles.QProcessRole;
import com.netgrif.application.engine.petrinet.service.interfaces.IProcessRoleService;
import com.netgrif.application.engine.workflow.service.interfaces.IFilterImportExportService;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class UserService
extends AbstractUserService {
    @Autowired
    protected UserRepository userRepository;
    @Autowired
    protected AuthorityRepository authorityRepository;
    @Autowired
    protected IProcessRoleService processRoleService;
    @Autowired
    protected ApplicationEventPublisher publisher;
    @Autowired
    protected INextGroupService groupService;
    @Autowired
    protected IRegistrationService registrationService;
    @Autowired
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    private GroupConfigurationProperties groupProperties;
    @Autowired
    private IFilterImportExportService filterImportExportService;

    @Override
    public IUser saveNewAndAuthenticate(IUser user) {
        return this.saveNew(user, true);
    }

    @Override
    public IUser saveNew(IUser user) {
        return this.saveNew(user, false);
    }

    private IUser saveNew(IUser user, boolean login) {
        this.registrationService.encodeUserPassword((RegisteredUser)user);
        this.addDefaultRole(user);
        this.addDefaultAuthorities(user);
        User savedUser = (User)this.userRepository.save((User)user);
        this.filterImportExportService.createFilterImport(user);
        this.filterImportExportService.createFilterExport(user);
        if (this.groupProperties.isDefaultEnabled()) {
            this.groupService.createGroup(user);
        }
        if (this.groupProperties.isSystemEnabled()) {
            this.groupService.addUserToDefaultGroup(user);
        }
        this.publisher.publishEvent((ApplicationEvent)new UserRegistrationEvent(savedUser));
        return savedUser;
    }

    @Override
    public AnonymousUser saveNewAnonymous(AnonymousUser user) {
        this.addAnonymousRole(user);
        this.addAnonymousAuthorities(user);
        return (AnonymousUser)this.userRepository.save(user);
    }

    @Override
    public User update(IUser user, UpdateUserRequest updates) {
        User dbUser = (User)user;
        if (updates.telNumber != null) {
            dbUser.setTelNumber(updates.telNumber);
        }
        if (updates.avatar != null) {
            dbUser.setAvatar(updates.avatar);
        }
        if (updates.name != null) {
            dbUser.setName(updates.name);
        }
        if (updates.surname != null) {
            dbUser.setSurname(updates.surname);
        }
        dbUser = (User)this.userRepository.save(dbUser);
        return dbUser;
    }

    public void addDefaultRole(User user) {
        user.addProcessRole(this.processRoleService.defaultRole());
    }

    public void addAnonymousRole(User user) {
        user.addProcessRole(this.processRoleService.anonymousRole());
    }

    public void addDefaultAuthorities(User user) {
        if (user.getAuthorities().isEmpty()) {
            HashSet<Authority> authorities = new HashSet<Authority>();
            authorities.add(this.authorityRepository.findByName("ROLE_USER"));
            user.setAuthorities(authorities);
        }
    }

    public void addAnonymousAuthorities(User user) {
        if (user.getAuthorities().isEmpty()) {
            HashSet<Authority> authorities = new HashSet<Authority>();
            authorities.add(this.authorityRepository.findByName("ROLE_ANONYMOUS"));
            user.setAuthorities(authorities);
        }
    }

    @Override
    public IUser findByAuth(Authentication auth) {
        return this.findByEmail(auth.getName(), false);
    }

    @Override
    public IUser save(IUser user) {
        return (IUser)this.userRepository.save((User)user);
    }

    @Override
    public IUser findById(String id, boolean small) {
        Optional user = this.userRepository.findById(id);
        if (user.isEmpty()) {
            throw new IllegalArgumentException("Could not find user with id [" + id + "]");
        }
        return (IUser)user.get();
    }

    @Override
    public IUser resolveById(String id, boolean small) {
        return this.findById(id, small);
    }

    @Override
    public IUser findByEmail(String email, boolean small) {
        return this.userRepository.findByEmail(email);
    }

    @Override
    public IUser findAnonymousByEmail(String email, boolean small) {
        return this.findByEmail(email, small);
    }

    @Override
    public List<IUser> findAll(boolean small) {
        return this.changeType(this.userRepository.findAll());
    }

    @Override
    public Page<IUser> findAllCoMembers(LoggedUser loggedUser, boolean small, Pageable pageable) {
        Set<String> members = this.groupService.getAllCoMembers(loggedUser.getSelfOrImpersonated().transformToUser());
        members.add(loggedUser.getSelfOrImpersonated().getId());
        Set<ObjectId> objMembers = members.stream().map(ObjectId::new).collect(Collectors.toSet());
        return this.changeType(this.userRepository.findAllBy_idInAndState(objMembers, UserState.ACTIVE, pageable), pageable);
    }

    @Override
    public Page<IUser> searchAllCoMembers(String query, LoggedUser loggedUser, Boolean small, Pageable pageable) {
        Set<String> members = this.groupService.getAllCoMembers(loggedUser.getSelfOrImpersonated().transformToUser());
        members.add(loggedUser.getSelfOrImpersonated().getId());
        return this.changeType(this.userRepository.findAll((Predicate)this.buildPredicate(members.stream().map(ObjectId::new).collect(Collectors.toSet()), query), pageable), pageable);
    }

    @Override
    public Page<IUser> searchAllCoMembers(String query, List<ObjectId> roleIds, List<ObjectId> negateRoleIds, LoggedUser loggedUser, Boolean small, Pageable pageable) {
        if ((roleIds == null || roleIds.isEmpty()) && (negateRoleIds == null || negateRoleIds.isEmpty())) {
            return this.searchAllCoMembers(query, loggedUser, small, pageable);
        }
        if (negateRoleIds == null) {
            negateRoleIds = new ArrayList<ObjectId>();
        }
        Set<String> members = this.groupService.getAllCoMembers(loggedUser.getSelfOrImpersonated().transformToUser());
        members.add(loggedUser.getSelfOrImpersonated().getId());
        BooleanExpression predicate = this.buildPredicate(members.stream().map(ObjectId::new).collect(Collectors.toSet()), query);
        if (roleIds != null && !roleIds.isEmpty()) {
            predicate = predicate.and((Predicate)((QProcessRole)QUser.user.processRoles.any())._id.in(roleIds));
        }
        predicate = predicate.and((Predicate)((QProcessRole)QUser.user.processRoles.any())._id.in(negateRoleIds).not());
        Page users = this.userRepository.findAll((Predicate)predicate, pageable);
        return this.changeType(users, pageable);
    }

    private BooleanExpression buildPredicate(Set<ObjectId> members, String query) {
        BooleanExpression predicate = QUser.user._id.in(members).and((Predicate)QUser.user.state.eq((Object)UserState.ACTIVE));
        for (String word : query.split(" ")) {
            predicate = predicate.andAnyOf(new Predicate[]{QUser.user.email.containsIgnoreCase(word), QUser.user.name.containsIgnoreCase(word), QUser.user.surname.containsIgnoreCase(word)});
        }
        return predicate;
    }

    @Override
    public Page<IUser> findAllActiveByProcessRoles(Set<String> roleIds, boolean small, Pageable pageable) {
        Page<User> users = this.userRepository.findDistinctByStateAndProcessRoles__idIn(UserState.ACTIVE, new ArrayList<String>(roleIds), pageable);
        return this.changeType(users, pageable);
    }

    @Override
    public List<IUser> findAllByProcessRoles(Set<String> roleIds, boolean small) {
        List<User> users = this.userRepository.findAllByProcessRoles__idIn(new ArrayList<String>(roleIds));
        return this.changeType(users);
    }

    @Override
    public List<IUser> findAllByIds(Set<String> ids, boolean small) {
        List<User> users = this.userRepository.findAllBy_idIn(ids.stream().map(ObjectId::new).collect(Collectors.toSet()));
        return this.changeType(users);
    }

    @Override
    public IUser assignAuthority(String userId, String authorityId) {
        Optional user = this.userRepository.findById(userId);
        Optional authority = this.authorityRepository.findById(authorityId);
        if (user.isEmpty()) {
            throw new IllegalArgumentException("Could not find user with id [" + userId + "]");
        }
        if (authority.isEmpty()) {
            throw new IllegalArgumentException("Could not find authority with id [" + authorityId + "]");
        }
        ((User)user.get()).addAuthority((Authority)authority.get());
        ((Authority)authority.get()).addUser((IUser)user.get());
        return (IUser)this.userRepository.save((User)user.get());
    }

    @Override
    public IUser getLoggedOrSystem() {
        try {
            if (SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof String) {
                return this.getSystem();
            }
            return this.getLoggedUser();
        }
        catch (NullPointerException e) {
            return this.getSystem();
        }
    }

    @Override
    public IUser getSystem() {
        User system = this.userRepository.findByEmail("engine@netgrif.com");
        system.setProcessRoles(new HashSet<ProcessRole>(this.processRoleService.findAll()));
        return system;
    }

    @Override
    public IUser getLoggedUser() {
        LoggedUser loggedUser = this.getLoggedUserFromContext();
        if (!loggedUser.isAnonymous()) {
            IUser user = this.findByEmail(loggedUser.getEmail(), false);
            if (loggedUser.isImpersonating()) {
                IUser impersonated = loggedUser.getImpersonated().transformToUser();
                impersonated.setProcessRoles(this.processRoleService.findByIds(loggedUser.getImpersonated().getProcessRoles()));
                user.setImpersonated(impersonated);
            }
            return user;
        }
        return loggedUser.transformToAnonymousUser();
    }

    @Override
    public LoggedUser getAnonymousLogged() {
        if (SecurityContextHolder.getContext().getAuthentication().getPrincipal().equals("anonymousUser")) {
            return this.getLoggedUser().transformToLoggedUser();
        }
        return this.getLoggedUserFromContext();
    }

    @Override
    public LoggedUser getLoggedUserFromContext() {
        return (LoggedUser)((Object)SecurityContextHolder.getContext().getAuthentication().getPrincipal());
    }

    @Override
    public void deleteUser(IUser user) {
        User dbUser = (User)user;
        if (!this.userRepository.findById(dbUser.getStringId()).isPresent()) {
            throw new IllegalArgumentException("Could not find user with id [" + dbUser.get_id() + "]");
        }
        this.userRepository.delete(dbUser);
    }

    private User loadGroups(User user) {
        if (user == null) {
            return null;
        }
        user.setNextGroups(this.groupService.getAllGroupsOfUser(user));
        return user;
    }
}

